//
//  WCVCFDataController.h
//
//  NOTE
//  ---------------------------
//  1. 改用AddressBook提供的vCard相關函式
//  2. AddressBook提供的vCard相關函式可處理一個vcf裡有多筆contact，但目前還是以一筆contact為主。
//  3. Anniversary/Other Date因在AddressBook元件裡寫入vcf會異常，暫時先跳過。 (iOS 9.0)
//  4. displayName統一由外部產生，不要在資料元件裡面撈設定值。
//


#import <Foundation/Foundation.h>
#import "WCCardModel.h"
#import "CrossPlatformDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
/// vCard file extension

extern NSString * const WCVCFDataController_FileExt; // vcf


////////////////////////////////////////////////////////////////////////////////////////////////////

/// Error code of WCVCFDataController
typedef NS_OPTIONS(NSInteger, WCVCFDataController_Error)
{
    WCVCFDataController_Error_Unknown = 0,
    WCVCFDataController_Error_InvalidParameters,
    WCVCFDataController_Error_FailedToConvert,
    WCVCFDataController_Error_FailedToAccessFile,
};


////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCVCFDataController : NSObject

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Class Method

/**
 * 檢查操作權限 （init前一定要使用）
 *
 * @param completion - completion block
 */
+ (void)checkAccessPermissionWithCompletion:(void (^)(BOOL authorized))completion;




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance Method

/**
 * initialize
 *
 * @param error - return error
 * @return WCABDataController instance
 */
- (id)initWithError:(NSError **)error;


/**
 * 從vCard字串產生WCCardModel
 *
 * @param vCardString - vCard字串
 * @param encoding - 輸入的vCard字串Encoding格式 (錯誤的格式可能會導致crash)
 * @param generateHiragana - 是否產生日文讀音，日文版請填YES。
 * @param error - return error
 * @return WCCardModel with fieldData
 */
- (WCCardModel *)cardModelFromVCardString:(NSString *)vCardString
                                 encoding:(NSStringEncoding)encoding
                         generateHiragana:(BOOL)generateHiragana
                                    error:(NSError **)error;


/**
 * Generate vCard string from WCCardModel
 *
 * @param cardModel - WCCardModel with fieldData
 * @param encoding - 輸出的vCard字串Encoding格式
 * @param error - return error
 * @return vCard string
 */
- (NSString *)vCardStringFromCardModel:(WCCardModel *)cardModel
                              encoding:(NSStringEncoding)encoding
                                 error:(NSError **)error;


/**
 * Read vCard file
 *
 * @param filePath - vCard file path
 * @param generateHiragana - 是否產生日文讀音，日文版請填YES。
 * @param error - return error
 * @return WCCardModel with fieldData
 */
- (WCCardModel *)readFileWithPath:(NSString *)filePath
                 generateHiragana:(BOOL)generateHiragana
                            error:(NSError **)error;


/**
 * Write vCard file
 *
 * @param filePath - vCard file path
 * @param cardModel - WCCardModel with fieldData
 * @param error - return error
 * @return YES if success
 */
- (BOOL)writeFileWithPath:(NSString *)filePath
                cardModel:(WCCardModel *)cardModel
                    error:(NSError **)error;


/**
 * Write vCard file
 *
 * @param filePath - vCard file path
 * @param cardModel - WCCardModel with fieldData
 * @param error - return error
 * @return YES if success
 */
- (BOOL)writeFileWithPath:(NSString *)filePath
                cardModel:(WCCardModel *)cardModel
                  IDPhoto:(CPImage *)IDPhoto
                    error:(NSError **)error;

@end
