//
//  WCToolController.h
//  WorldCardHD
//
//  Created by  Eddie on 2011/1/5.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import "WCSourceDefine.h"
#import "WCGroupDefine.h"

#import <QuartzCore/QuartzCore.h>

#define swap(x, y) ((x)^=(y)^=(x)^=(y));
#define WC_InvalidRecordID  -1
#define WC_CardIDLength     20


////////////////////////////////////////////////////////////////////////////////////////////////////
// Common definition
typedef void (^WCResultHandler)(BOOL result);


////////////////////////////////////////////////////////////////////////////////////////////////////
// System language definition
typedef enum {
    WC_SL_EN = 0,		// 英
    WC_SL_SC,			// 簡中
    WC_SL_TC,			// 繁中
    WC_SL_JA,			// 日
    WC_SL_KO,			// 韓
    WC_SL_FR,			// 法
    WC_SL_DE,			// 德
    WC_SL_NL,			// 荷蘭
    WC_SL_IT,			// 義大利
    WC_SL_ES,			// 西班牙
    WC_SL_PT,			// 葡萄牙
    WC_SL_TH,           // 泰文
    WC_SL_SW,           // 瑞典文
}
WC_SystemLanguage;

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCToolController : NSObject
{

}


/// 檢查並建立路徑中的目錄
+ (BOOL)createDirPath:(NSString *)dirPath;

/// get share folder path
+ (NSString *)shareFolderPath;

/// 暫存目錄
+ (NSString *)tempFolderPath;

/// 建立/取得資料儲存的根目錄
+ (NSString *)baseStorePathWithDirName:(NSString *)dirName;

/// 建立/取得資料儲存的根目錄
+ (NSString *)baseStorePathWithDirName:(NSString *)dirName isCreatDirPath:(BOOL)isCreatDirPath;;

/// 取得系統language設定
+ (WC_SystemLanguage)systemLanguage;

/// 取得系統region設定
+ (NSString *)systemRegion;

/// get application version
+ (NSString *)appVersion;

/// get application version
+ (NSString *)appBundleID;

/// 判斷是否為中日韓字串
+ (BOOL)isCJKString:(NSString *)string;

/// 判斷是否為英文字串
+ (BOOL)isEngString:(NSString *)string;

/// 判斷是否為漢字姓名
+ (BOOL)isEasternNameWithFirstName:(NSString *)firstName lastName:(NSString *)lastName;

/// 濾除公司名稱字串
+ (NSString *)trimCompanyPrefix:(NSString *)oriCompanyName;

/// generate cardID of 20 char
+ (NSString *)generateCardID;

/// use common fade animation
+ (void)addCommonFadeAnimationWithLayer:(CALayer *)layer delegate:(id)delegate;


/*
/// 取得硬體代號
+ (NSString *)phoneModel;

/// check if retina display device
+ (BOOL)isRetinaDisplay;

/// get OS main version (*.*)
+ (CGFloat)OSMainVersion;

/// get transform value by device orientation
+ (CGAffineTransform)transformFromOrientation:(UIInterfaceOrientation)orientation;

/// 強制介面以指定方向顯示
+ (void)forceDisplayWithOrientation:(UIInterfaceOrientation)orientation contentView:(UIView *)contentView;

/// 調整navgarionBar高度
+ (NSInteger)adjustNavBarHeight:(UINavigationController *)navController __attribute__((deprecated));

///andy 系統可用空間
+ (unsigned long long int)systemCanUseSpace;

///andy folder佔用空間
+ (unsigned long long int)folderSize:(NSString *)folderPath;
*/ 

@end
