//
//  WCTServerVersionController.h
//  Pods
//
//  Created by sanhue on 2017/5/23.
//
//

#import "WCTRestClientController.h"
#import "PPVersionInfo.h"

typedef NS_ENUM(NSInteger, WCTServerCanLoginResult)
{
    WCTServerCanLoginResult_YES = 1,                ///< 大版號一致或client比較新，可以登入
    WCTServerCanLoginResult_NO_ServerIsNewer,       ///< 大版號不一致，不能登入，且server較新
    WCTServerCanLoginResult_NO_UnsupportedServerVersion,       ///< 不支援的server版本，server版本<向下相容版號
    WCTServerCanLoginResult_NO_ClientIsNewer __deprecated,       ///< 大版號不一致，不能登入，且client較新 目前用不到了
};

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCTRestClientController (Version)

#pragma mark - Class methods

/**
 * 設定client支援的server版號的上下限，
 * @param minServerVersion client支援的server的最小版號, 如4.0表示要4.0以上才支援，不能是nil
 * @param maxServerVersion client支援的server的最大版號, 如4.0表示5.0以下才支援，不能是nil
 */
+ (void)setClientSupportedMinServerVersion:(NSString*)minServerVersion maxServerVersion:(NSString*)maxServerVersion;


/**
 寫入,目前支援的最小版號
 
 @param supportedVersion 支援的伺服器版號
 */
+ (void)setCurLastMininumSupportedVersion:(NSString *)supportedVersion;


/**
 目前支援最小版號
 */
+ (NSString *)curLastMinumSupportedVersion;



/**
 紀錄最後一次登入成功(online)時的server版本
 
 @param serverVersion 伺服器版號
 */
+ (void)setLastLoginServerVersion:(NSString *)serverVersion;


/**
 取得最後一次登入成功(online)時的server版本
 */
+ (NSString *)lastLoginServerVersion;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

/**
 * 是否可登入server，因為有用到WCTRestClientController, 需在background thread使用，
 * 大版號不一致就不能登入, 如果要顯示其他訊息，可參考WCTServerCanLoginResult_NO_ServerIsNewer，WCTServerCanLoginResult_NO_ClientIsNewer決定
 * @param error 回傳錯誤
 * @return 檢查結果 WCTServerCanLoginResult
 */
- (WCTServerCanLoginResult)canLoginWithError:(NSError **)error;

/**
 * 是否可登入server，因為有用到WCTRestClientController, 需在background thread使用，
 * 大版號不一致就不能登入, 如果要顯示其他訊息，可參考WCTServerCanLoginResult_NO_ServerIsNewer，WCTServerCanLoginResult_NO_ClientIsNewer決定
 * @return 檢查結果 WCTServerCanLoginResult
 */
- (WCTServerCanLoginResult)canLogin;

/**
 * 最小可支援的版本，取server版號與軟體版號中較小的值
 * @return 最小版號 支援的版號(NSString)
 */
- (NSString*)minSupportedVersion;


@end
