//
//  WCTRestClientController+ErrorCodeDefine.h
//  
//
//  Created by Howard on 2016/3/18.
//
//

#ifndef WCTRestClientController_ErrorCodeDefine_h
#define WCTRestClientController_ErrorCodeDefine_h

////////////////////////////////////////////////////////////////////////////////////////////////////
typedef NS_ENUM(NSUInteger, WCTRestClientController_ErrorCode)
{
    WCTRestClientController_ErrorCode_None = 0,
    
    WCTRestClientController_ErrorCode_ServerRestored                = 10000,     // 登入時判斷到server已還原，需要登出
    WCTRestClientController_ErrorCode_ServerVersionIsNewer,                      // 伺服器版本比較新
    WCTRestClientController_ErrorCode_UnsupportedServerVersion,                  // 不支援的伺服版本
    WCTRestClientController_ErrorCode_LoginAfterServerUpdated,                   // server更新後的第一次背景登入，需要登出
};


typedef NS_ENUM(NSUInteger, WCTServer_Common_ErrorCode)
{
    WCTServer_Common_ErrorCode_AuthenticationFailed         = 401,
    WCTServer_Common_ErrorCode_PermissionDenied             = 403,  // 沒有權限做此操作
    WCTServer_Common_ErrorCode_DataNotFound                 = 404,  // server存在但資源不存在
    WCTServer_Common_ErrorCode_LicenseIsInvalid             = 405,  // license code is invalid
    WCTServer_Common_ErrorCode_InvalidParameter             = 422,  // 資料格式錯誤（ex: 1.長度超過限制, 2.建立多層類別,超過層數上限）
    WCTServer_Common_ErrorCode_AccountIsInheriting          = 423,  // 帳號繼承處理中
    WCTServer_Common_ErrorCode_OverPrivateContactCountLimitation   = 425,  // 超過聯絡人數量上限 (私有區)
    WCTServer_Common_ErrorCode_OverPublicContactCountLimitation   = 426,  // 超過聯絡人數量上限 (公有區)
    WCTServer_Common_ErrorCode_OverServerContactCountLimitation   = 427,  // 超過聯絡人數量上限 (總筆數)
    WCTServer_Common_ErrorCode_NotEnoughServerSpace         = 431,  // 伺服器空間不足
    WCTServer_Common_ErrorCode_ServerMaintenance            = 432,  // 伺服器維護中 (garbage collection)
    WCTServer_Common_ErrorCode_ServerTaskCollision          = 443,  // server執行緒衝突(多個client同時寫入同一筆資料)
    WCTServer_Common_ErrorCode_ServerIsNewer                = 462,  // server資料比client新
    WCTServer_Common_ErrorCode_NotAllowedIP                 = 469,
    WCTServer_Common_ErrorCode_UnbindingDevice              = 482,
    WCTServer_Common_ErrorCode_SubscriptionLocked           = 485,  // Subscription mode service locked
    WCTServer_Common_ErrorCode_LimitedAccountAccessDenied   = 486,  // 暫停使用帳號，沒有權限操作
    WCTServer_Common_ErrorCode_GuidHasBeenUsed              = 490,  // 新增資料Guid已經存在
    WCTServer_Common_ErrorCode_Restoring                    = 498,  // 系統還原中
    WCTServer_Common_ErrorCode_Backuping                    = 499,  // 系統備份中
    WCTServer_Common_ErrorCode_RunTimeException             = 500,
};


////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, WCTServer_ChangePassword_ErrorCode)
{
    WCTServer_ChangePassword_ErrorCode_InvalidParameter = 403,
    WCTServer_ChangePassword_ErrorCode_ResourceNotFound = WCTServer_Common_ErrorCode_DataNotFound,
    WCTServer_ChangePassword_ErrorCode_NewPasswordShouldDifferentFromOld = 416,
    WCTServer_ChangePassword_ErrorCode_PasswordIncorrect = 460,
    WCTServer_ChangePassword_ErrorCode_InvalidFormat = 462,
    WCTServer_ChangePassword_ErrorCode_NotAllowedIP = WCTServer_Common_ErrorCode_NotAllowedIP,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, WCTServer_Login_ErrorCode)
{
    WCTServer_Login_ErrorCode_AuthenticationFailed = WCTServer_Common_ErrorCode_AuthenticationFailed,
    WCTServer_Login_ErrorCode_AccountNotFound = WCTServer_Common_ErrorCode_DataNotFound,
    WCTServer_Login_ErrorCode_LoginFailExceedAllowCount = 424,
    WCTServer_Login_ErrorCode_InvalidParameter = WCTServer_Common_ErrorCode_InvalidParameter,
    WCTServer_Login_ErrorCode_NotEnoughMemory = 427, //  < 8G physical memory
    WCTServer_Login_ErrorCode_LicenseNeedReactive = 429,
    WCTServer_Login_ErrorCode_LoginTimeIsLarge = 461,
    WCTServer_Login_ErrorCode_NotAllowedIP = WCTServer_Common_ErrorCode_NotAllowedIP,
    WCTServer_Login_ErrorCode_AD_AuthenticationFailed = 470,
    WCTServer_Login_ErrorCode_AD_FailToConnectServer = 471,
    WCTServer_Login_ErrorCode_AD_InvalidPassword = 472,
    WCTServer_Login_ErrorCode_AD_InvalidUsername = 473,
    WCTServer_Login_ErrorCode_AD_ExpiredPassword = 474,
    WCTServer_Login_ErrorCode_AD_ExpiredUserAccount = 475,
    WCTServer_Login_ErrorCode_AD_FirstLoginNeedChangePassword = 476,
    /**
     Indicates that during a bind operation one of the following occurred: The client passed either an incorrect DN or password, or the password is incorrect because it has expired, intruder detection has locked the account, or another similar reason.
     **/
    WCTServer_Login_ErrorCode_AD_NotLoginWithAccuont = 477,
    WCTServer_Login_ErrorCode_AD_ServerBusy = 478,
    WCTServer_Login_ErrorCode_AD_CanNotProcessRequest = 479,
    WCTServer_Login_ErrorCode_UnbindingDevice = WCTServer_Common_ErrorCode_UnbindingDevice,
    WCTServer_Login_ErrorCode_SubscriptionLocked = WCTServer_Common_ErrorCode_SubscriptionLocked,
    WCTServer_Login_ErrorCode_LockByLoginFailure = 488,          ///< 登入失敗次數太多，鎖定帳號
    WCTServer_Login_ErrorCode_LockByAccountActiveExpire = 489,   ///< 超過期期限沒有啟動帳號，鎖定帳號
    WCTServer_Login_ErrorCode_RunTimeException = WCTServer_Common_ErrorCode_RunTimeException,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, WCTServer_RefreshToken_ErrorCode)
{
    WCTServer_RefreshToken_ErrorCode_AuthenticationFailed = WCTServer_Common_ErrorCode_AuthenticationFailed,
    WCTServer_RefreshToken_ErrorCode_TokenExpired = 460,
    WCTServer_RefreshToken_ErrorCode_TokenInvalid = 461,
    WCTServer_RefreshToken_ErrorCode_RunTimeException = WCTServer_Common_ErrorCode_RunTimeException,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, WCTServer_CategorySetOrder_ErrorCode)
{
    WCTServer_CategorySetOrder_ErrorCode_AuthenticationFailed = WCTServer_Common_ErrorCode_AuthenticationFailed,
    WCTServer_CategorySetOrder_ErrorCode_ServerIsEqualToClient = 409,
    WCTServer_CategorySetOrder_ErrorCode_ServerIsNewer = WCTServer_Common_ErrorCode_ServerIsNewer,
    WCTServer_CategorySetOrder_ErrorCode_RunTimeException = WCTServer_Common_ErrorCode_RunTimeException,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, WCTServer_HelpScanning_ErrorCode)
{
    WCTServer_HelpScanning_ErrorCode_AccountIsResigned = 441,   // 幫助掃描的名片上傳時帳號已離職
};


////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, WCTServer_UpdateCRMToken_ErrorCode)
{
    WCTServer_UpdateCRMToken_ErrorCode_PermissionDenied = 403,   // 沒有權限
    WCTServer_UpdateCRMToken_ErrorCode_CRMOperationFailed = 409,
    WCTServer_UpdateCRMToken_ErrorCode_RunTimeException = WCTServer_Common_ErrorCode_RunTimeException,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, WCTServer_ChangeDisplayName_ErrorCode)
{
    WCTServer_ChangeDisplayName_ErrorCode_PermissionDenied = WCTServer_Common_ErrorCode_PermissionDenied,   // Request required parameters not valid.
    WCTServer_ChangeDisplayName_ErrorCode_AlreadyExistName = 415, // User name already in use.
    WCTServer_ChangeDisplayName_ErrorCode_RunTimeException = WCTServer_Common_ErrorCode_RunTimeException, // Unknow exception
};

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, WCTServer_ExchangeServer_ErrorCode)
{
	WCTServer_ExchangeServer_ErrorCode_LoginFailed = 400,
    WCTServer_ExchangeServer_ErrorCode_PermissionDenied = WCTServer_Common_ErrorCode_PermissionDenied,   // Request required parameters not valid.
    WCTServer_ExchangeServer_ErrorCode_DisabledByManager = WCTServer_Common_ErrorCode_DataNotFound,
    WCTServer_ExchangeServer_ErrorCode_PermissionError = 409,
    WCTServer_ExchangeServer_ErrorCode_ServerTypeNotMatch = 415, // exchange Server Type not match
    WCTServer_ExchangeServer_ErrorCode_RunTimeException = WCTServer_Common_ErrorCode_RunTimeException, // Unknow exception
};


////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, WCTServer_QcontactzSetting_ErrorCode)
{
    WCTServer_QcontactzSetting_ErrorCode_LoginFailed = 400,
    WCTServer_QcontactzSetting_ErrorCode_PermissionDenied = WCTServer_Common_ErrorCode_PermissionDenied,   // Request required parameters not valid.
    WCTServer_QcontactzSetting_ErrorCode_OperationFailed = 409,
    WCTServer_QcontactzSetting_ErrorCode_NotAllowedIP = WCTServer_Common_ErrorCode_NotAllowedIP,
    WCTServer_QcontactzSetting_ErrorCode_RunTimeException = WCTServer_Common_ErrorCode_RunTimeException, // Unknow exception
};





////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, WCTServer_QcontactzLogin_ErrorCode)
{
    WCTServer_QcontactzLogin_ErrorCode_LoginFailed = 400,
    WCTServer_QcontactzLogin_ErrorCode_PermissionDenied = WCTServer_Common_ErrorCode_PermissionDenied,
    WCTServer_QcontactzLogin_ErrorCode_OperationFailed = 409,
    WCTServer_QcontactzLogin_ErrorCode_NotInstallQcontactzService = 450,
    WCTServer_QcontactzLogin_ErrorCode_NotAllowedIP = WCTServer_Common_ErrorCode_NotAllowedIP,
    WCTServer_QcontactzLogin_ErrorCode_RunTimeException = WCTServer_Common_ErrorCode_RunTimeException
};





////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, WCTServer_PublicContactSearch_ErrorCode)
{
    WCTServer_PublicContactSearch_ErrorCode_PermissionDenied = 403,   // 沒有權限
    WCTServer_PublicContactSearch_ErrorCode_InvalidParameter = WCTServer_Common_ErrorCode_InvalidParameter,   // 資料格式錯誤
    WCTServer_PublicContactSearch_ErrorCode_RequestLimit = WCTServer_Common_ErrorCode_OverPrivateContactCountLimitation,
    WCTServer_PublicContactSearch_ErrorCode_NotAllowedIP = WCTServer_Common_ErrorCode_NotAllowedIP,
    WCTServer_PublicContactSearch_ErrorCode_SearchEngineInitializing = 491, // 搜尋引擎準備中
    WCTServer_PublicContactSearch_ErrorCode_SearchEngineNotRunning = 492, // 搜尋引擎已中斷
    WCTServer_PublicContactSearch_ErrorCode_SearchDataMissing = 493, // 搜尋資料不見了 (應該不會發生)
    WCTServer_PublicContactSearch_ErrorCode_SearchEngineException = 494, // 搜尋引擎回傳錯誤
    WCTServer_PublicContactSearch_ErrorCode_SearchResultOutOfDate = 495, // 因為空間不足，搜尋結果不是最新的
    WCTServer_PublicContactSearch_ErrorCode_RunTimeException = WCTServer_Common_ErrorCode_RunTimeException, // Unknow exception
};

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, WCTServer_Category_ErrorCode)
{
    /// 超過群組層數限制
    WCTServer_Category_ErrorCode_OverLayerCountLimitation = 428,

    /// 群組名稱已存在
    WCTServer_Category_ErrorCode_NameAlreadyExists = 460,

    /// 刪除還有資料的群組
    WCTServer_Category_ErrorCode_DeleteNonEmptyCategory = 480,

};

#endif /* WCTRestClientController_ErrorCodeDefine_h */

