//
//  WCTRestClient+StatisticInfo.h
//  
//
//  Created by Howard on 2016/3/10.
//
//

#import "WCTRestClient.h"

// Model
#import "WCTRCTotalActivityInfosResponseResult.h"
#import "WCTRCAuthorizedInfoResponseResult.h"
#import "WCTRCTotalContactInfosResponseResult.h"
#import "WCTRCStorageInfoResponseResult.h"
#import "WCTRCTotalTaskInfosResponseResult.h"

@interface WCTRestClient (StatisticInfo)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

/**
 *  取得所有活動紀錄
 *
 *  @param loginToken 登入 Token
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)totalActivityInfosWithLoginToken:(NSString *)loginToken
                                                       success:(void (^)(WCTRCTotalActivityInfosResponseResult *activityInfoResponseResult))success
                                                       failure:(void (^)(NSError *error))failure;


/**
 *  取得授權紀錄
 *
 *  @param loginToken 登入 Token
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)authorizedInfoWithLoginToken:(NSString *)loginToken
                                                   success:(void (^)(WCTRCAuthorizedInfoResponseResult *authorizedInfoResponseResult))success
                                                   failure:(void (^)(NSError *error))failure;


/**
 *  取得所有帳號資訊
 *
 *  @param loginToken 登入 Token
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)totalContactInfosWithLoginToken:(NSString *)loginToken
                                                      success:(void (^)(WCTRCTotalContactInfosResponseResult *authorizedInfoResponseResult))success
                                                      failure:(void (^)(NSError *error))failure;


/**
 *  取得儲存空間資訊
 *
 *  @param loginToken 登入 Token
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)storageInfoWithLoginToken:(NSString *)loginToken
                                                success:(void (^)(WCTRCStorageInfoResponseResult *storageInfoResponseResult))success
                                                failure:(void (^)(NSError *error))failure;


/**
 *  取得所有任務資訊
 *
 *  @param loginToken 登入 Token
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)totalTaskInfosWithLoginToken:(NSString *)loginToken
                                                   success:(void (^)(WCTRCTotalTaskInfosResponseResult *totalTaskInfosResponseResult))success
                                                   failure:(void (^)(NSError *error))failure;

@end
