//
//  WCTRestClient+Category.h
//  
//
//  Created by Howard on 2016/3/15.
//
//

#import "WCTRestClient.h"

// Model
#import "WCTRCCategoryInfoListResponseResult.h"
#import "WCTRCCategoryCreateResponseResult.h"
#import "WCTRCCategoryDeleteResponseResult.h"
#import "WCTRCCategoryUpdateResponseResult.h"
#import "WCTRCCategoryOrderResponseResult.h"
#import "WCTRCCategoryOrderInfoRequest.h"
#import "WCTRCCategoryOrderInfoResponseResult.h"
#import "WCTRCDateTimeResponseResult.h"


@interface WCTRestClient (Category)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method


/**
 *  建立類別
 *
 *  @param loginToken   登入 Token
 *  @param categoryName 類別名稱
 *  @param clientCreatedCategoryGuid 類別guid
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)createCategoryWithLoginToken:(NSString *)loginToken
                                              categoryName:(NSString *)categoryName
                                 clientCreatedCategoryGuid:(NSString *)clientCreatedCategoryGuid
                                                   success:(void (^)(WCTRCCategoryCreateResponseResult *categoryCreateResponseResult))success
                                                   failure:(void (^)(NSError *error))failure;


/**
 *  刪除類別
 *
 *  @param loginToken 登入 Token
 *  @param categoryGuids 刪除類別Guid (The NSString of NSArray)
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)deleteCategoryWithLoginToken:(NSString *)loginToken
                                             categoryGuids:(NSArray *)categoryGuids
                                                   success:(void (^)(WCTRCCategoryDeleteResponseResult *categoryDeleteResponseResult))success
                                                   failure:(void (^)(NSError *error))failure;


/**
 *  更新類別
 *
 *  @param loginToken    登入 Token
 *  @param newCategoryName 新的類別名稱
 *  @param categoryGuid    類別Guid
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)updateCategoryWithLoginToken:(NSString *)loginToken
                                           newCategoryName:(NSString *)newCategoryName
                                              categoryGuid:(NSString *)categoryGuid
                                                   success:(void (^)(WCTRCCategoryUpdateResponseResult *categoryUpdateResponseResult))success
                                                   failure:(void (^)(NSError *error))failure;


/**
 *  取得類別列表
 *
 *  @param loginToken  登入 Token
 *  @param accountGuid 帳號 ID
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)categoryListWithLoginToken:(NSString *)loginToken
                                             accountGuid:(NSString *)accountGuid
                                                 success:(void (^)(WCTRCCategoryInfoListResponseResult *categoryInfoListResponseResult))success
                                                 failure:(void (^)(NSError *error))failure;

/**
 *  更新類別順序
 *
 *  @param loginToken           登入 Token
 *  @param request 要設定的參數
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)categorySetOrderWithLoginToken:(NSString *)loginToken
                                                     request:(WCTRCCategoryOrderInfoRequest *)request
                                                     success:(void (^)(WCTRCDateTimeResponseResult *categoryOrderResponseResult))success
                                                     failure:(void (^)(NSError *error))failure;

/**
 *  取得server上的類別順序
 *
 *  @param loginToken           登入 Token
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)categoryGetOrderWithLoginToken:(NSString *)loginToken
                                                     success:(void (^)(WCTRCCategoryOrderInfoResponseResult *categoryGetOrderResponseResult))success
                                                     failure:(void (^)(NSError *error))failure;

@end
