//
//  WCTNoticeInfo.h
//  Pods
//
//  Created by sanhue on 2016/9/2.
//
//

#import "WCTRestObject.h"
#import "WCTRCCRMExportResult.h"

@interface WCTRCNoticeInfo : WCTRestObject

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property(nonatomic, retain) NSString *guid;
@property(nonatomic, retain) NSString *notifyCategory;
@property(nonatomic, retain) NSString *notifyContent;
@property(nonatomic, retain) NSDate *notifyTime;
@property(nonatomic, retain) NSString *notifyType;
@property(nonatomic, retain) NSString *senderGuid;
@property(nonatomic, retain) NSString *senderName;
@property(nonatomic, assign) BOOL viewed;






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - localized string methods

/// 如果沒有sender guid, 回傳系統通知的多語系字串，如果有，回傳sender name
- (NSString *)localizedSenderName;

/// 回傳多語系的通知title
- (NSString *)localizedNoticeTitle;

/// 回傳多語系的通知內文
- (NSString *)localizedNoticeContent;


#pragma mark - localized string methods CRM匯出專用

/// 回傳CRM匯出結果的成功字串
- (NSString *)CRMExportSuccessString;

/// 回傳CRM匯出結果的失敗字串
- (NSString *)CRMExportFailedString;

/// 回傳錯誤個數
- (NSNumber *)CRMExportFailedNumber;

- (WCTRCCRMExportResult *)crmExportResult;

@end
