//
//  WCTLoginController+ParameterDefine.h
//  
//
//  Created by Howard on 2017/7/3.
//
//

#ifndef WCTLoginController_ParameterDefine_h
#define WCTLoginController_ParameterDefine_h

#import "NSError+Custom.h"

typedef NS_ENUM(NSUInteger, WCTLoginController_ErrorCode)
{
    WCTLoginController_ErrorCode_IncompatibleVersion = NSErrorCustom_Code_UserDefine,
    WCTLoginController_ErrorCode_InvalidPassword,
    WCTLoginController_ErrorCode_InvalidServer,
    WCTLoginController_ErrorCode_InvalidUser,
    WCTLoginController_ErrorCode_AccountNotFound,
    WCTLoginController_ErrorCode_NetworkLessAndInvalidPassword,
    WCTLoginController_ErrorCode_NetworkLessAndInvalidUser,
    WCTLoginController_ErrorCode_OfflineModeTimeout,
    WCTLoginController_ErrorCode_EmailFormatIsIllegal,
    WCTLoginController_ErrorCode_PassowrdLengthIsIllegal,
    WCTLoginController_ErrorCode_PasswordFormatIsIllegal,
    WCTLoginController_ErrorCode_ConnecWebSiteFomatError,
    WCTLoginController_ErrorCode_WarningOfflineMode,
    WCTLoginController_ErrorCode_WarningOfflineModeWithUpdateClient,
    WCTLoginController_ErrorCode_WarningOfflineModeWithServerMaintainance,
    WCTLoginController_ErrorCode_WarningSwitchServer,
    WCTLoginController_ErrorCode_WarningSwitchUser,
    WCTLoginController_ErrorCode_WarningSwitchHttp,
    WCTLoginController_ErrorCode_NotFoundServerInNetworkArea,
    WCTLoginController_ErrorCode_FailToInitialObject,
    WCTLoginController_ErrorCode_ServerAddressEmpty,
    WCTLoginController_ErrorCode_ServerIsNewerThanClient,
    WCTLoginController_ErrorCode_ClientIsNewerThanServer,
    WCTLoginController_ErrorCode_UnsupportedServerVersion,
    WCTLoginController_ErrorCode_ServerIsUnActived,
    WCTLoginController_ErrorCode_ServerTrialExpired,
    WCTLoginController_ErrorCode_ServerNeedReIntital,
    WCTLoginController_ErrorCode_UpdateClientToUse,
    WCTLoginController_ErrorCode_ServerMaintainance,
    WCTLoginController_ErrorCode_TrialOutOfDate, // 試用過期，180天內可登入
    WCTLoginController_ErrorCode_TrialLeft2WeekOfDate,
    WCTLoginController_ErrorCode_SubscriptionOutOfDate, // 訂閱過期，180天內可登入
    WCTLoginController_ErrorCode_SubscriptionLeft2WeekOfDate,
    WCTLoginController_ErrorCode_LimitedAccount,    // 試用或訂閱期內被暫停使用，可登入
    WCTLoginController_ErrorCode_SubscriptionLock,  // 超過180天，無法登入
    
    WCTLoginController_ErrorCode_LockByLoginFailure,  // 登入失敗次數太多，無法登入
    WCTLoginController_ErrorCode_LockByAccountActiveExpired,  // 太久沒有啟動，無法登入

    WCTLoginController_ErrorCode_DuplicatedServerLock, // 伺服器鎖定
    WCTLoginController_ErrorCode_DuplicatedServerWarning, // 伺服器重覆
};


/// 變更密碼原因
typedef NS_ENUM(NSUInteger, WCTLC_ChangePasswordReason)
{
    WCTLC_ChangePasswordReason_No = 0,                ///< 不用變更
    WCTLC_ChangePasswordReason_FirstLogin = 1,        ///< 第一次登入
    WCTLC_ChangePasswordReason_PasswordExpired = 2,   ///< 超過設定天數未修改
};


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Port Define

static NSUInteger  const WCTLC_HttpPort  = 9080;
static NSUInteger  const WCTLC_HttpsPort  = 9443;
static NSUInteger  const WCTLC_PublicCloudHttpPort  = 80;
static NSUInteger  const WCTLC_PublicCloudHttpsPort  = 443;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Server Name Define

static NSString * const WCTLoginControllerServerName  = @"WorldCardTeam";
static NSString * const WCTLC_PublicCloudDomain = @"worldcardteam.com";         // 公開的私有雲

static NSString * const WCTLC_PublicCloudDomain_WCT = @"wct.worldcardteam.com"; // 公有雲
static NSString * const WCTLC_PublicCloudDomain_New = @"app.worldcardcloud.com"; // 新的公有雲

static NSString * const WCTLC_PublicCloudUrl = @"https://app.worldcardcloud.com";
static NSString * const WCTLC_PublicCloudUrl_WCT = @"https://wct.worldcardteam.com";

static NSString * const WCTLC_PublicCloudRegisterUrl = @"https://reg.worldcardcloud.com/registerHome?upgradeFromRetail="; //註冊網址


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Password Lenght Define

static NSInteger const WCTLoginController_MinimumPassword = 6;
static NSInteger const WCTLoginController_MaximumPassword = 16;








////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Error Key

static NSString *  const WCTLoginControllerErrorInfoKey_Login  = @"WCTLoginControllerErrorInfoKey_Login";
static NSString *  const WCTLoginControllerErrorInfoKey_Subscription  = @"WCTLoginControllerErrorInfoKey_Subscription";
static NSString *  const WCTLoginControllerErrorInfoKey_DuplicatedServer  = @"WCTLoginControllerErrorInfoKey_DuplicatedServer";


#endif /* WCTLoginController_ParameterDefine_h */
