//
//  WCCardDBDefine.h
//  Pods
//
//  Created by sanhue on 2015/5/22.
//
//

#ifndef Pods_WCCardDBDefine_h
#define Pods_WCCardDBDefine_h



typedef NS_ENUM(NSInteger, WCTCDBC_RecordType)
{
    WCTCDBC_RT_None,
    WCTCDBC_RT_Field,
    WCTCDBC_RT_Group,
};


typedef NS_ENUM(NSInteger, WCTTable_Index_Key)
{
    WCTTable_None = 0,
    WCTTable_WCInfo = 1,
    WCTTable_WCGroup,
    WCTTable_WCCardGroup,
    WCTTable_WCFavorite,
    WCTTable_WCCard,
    WCTTable_WCCardField,
    WCTTable_WCDeletedGroupID,
    WCTTable_WCDeletedFieldID,
    WCTTable_WCUnverified,
    WCTTable_WCUserDefinedFieldLabel,//WCM 6.4.0新增
    WCTTable_WCRecentContacts, //WCM 7.0.0新增
    WCTTable_WCAddressBookMapping, //WCM 7.0.0新增
    WCTTable_WCTCardSyncAction, // WCT 新增
    WCTTable_WCTCardSyncErrorInfo, // WCT 新增
    WCTTable_WCTGroupSyncAction, // WCT 新增
    WCTTable_WCTAccountRelationship, // WCT 新增
    WCTTable_WCTCardSharedAccount, // WCT 新增
    WCTIndex_WCCardGroup,
    WCTIndex_WCFavorite,
    WCTIndex_WCCard,
    WCTIndex_WCCardField,
    WCTIndex_WCRecentContacts, //WCM 7.0.0新增
    WCTIndex_WCAddressBookMapping, //WCM 7.0.0新增
    WCTIndex_WCTCardSyncAction, // WCT 新增
    WCTIndex_WCTCardSyncErrorInfo, // WCT 新增
    WCTIndex_WCTGroupSyncAction, // WCT 新增
    WCTIndex_WCTAccountRelationship, // WCT 新增
    WCTIndex_WCTCardSharedAccount, // WCT 新增
};



////////////////////////////////////////////////////////////////////////////////////////////////
// general definition

#define WCTCDBC_ThreadDict_kInterrupt       @"WCTCDBC_ThreadDict_kInterrupt"


#define WCTCDBC_DateTimeFormat              @"yyyy-MM-dd HH:mm:ss"

#define WCTCDBC_UserInfoKey_DBErrorStep     @"DBErrorStep"
#define WCTCDBC_UserInfoKey_DBErrorMessage  @"DBErrorMessage"

// category order modified time
#define WCTCDBC_UserInfoKey_CategoryOrderModifiedTime     @"CategoryOrderModifiedTime"

#define WCTCDBC_IK_Version                  @"Version" // value is string type



////////////////////////////////////////////////////////////////////////////////////////////////
// version definition
// 請把版號異動相關資料都記錄下來

// 100為初始版本
#define WCTCDBC_FormatVersion_V100 @"100"

// 130異動：WCGroup新增欄位SuperGroupGuid / IsPinned
#define WCTCDBC_FormatVersion_V130 @"130"

// 140: 加入泰文，瑞典文的indexing
#define WCTCDBC_FormatVersion_V140 @"140"

// 141: 升級時清除地址包含科學園區的聯絡人的GPS
#define WCTCDBC_FormatVersion_V141 @"141"


// 指定目前版本
//#define WCTCDBC_CurrentVersion WCTCDBC_FormatVersion_V100
#define WCTCDBC_CurrentVersion WCTCDBC_FormatVersion_V141


#endif
