//
//  WCRecognitionFieldModel.h
//
//
//  Created by Howard.Lin on 13/12/10.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "WCRecognitionFieldDefine.h"
#import "WCRecognitionContextModel.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCRecognitionFieldModel : NSObject
{
    @protected
     WCRecognitionFieldMainType  fieldMainType_;
     WCRecognitionFieldLabelType fieldLabelType_;
     WCRecognitionFieldSource    fieldSource_;

     NSUInteger                  fieldOrder_;
     NSMutableDictionary         *recognitionContextModelDictionary_;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,assign) WCRecognitionFieldMainType  fieldMainType;
@property (nonatomic,assign) WCRecognitionFieldLabelType fieldLabelType;
@property (nonatomic,assign) WCRecognitionFieldSource    fieldSource;
@property (nonatomic,assign) NSUInteger                  fieldOrder;
@property (nonatomic,retain) NSMutableDictionary         *recognitionContextModelDictionary;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

- (BOOL)validRecognitionFieldModel;

- (NSNumber *)keyForWCRecognitionFieldSubType:(WCRecognitionFieldSubType)subType;

- (void)setWCRecognitionContextModel:(WCRecognitionContextModel *)recognitionContextModel forWCRecognitionFieldSubType:(WCRecognitionFieldSubType)subType;

- (WCRecognitionContextModel *)recognitionContextModelForWCRecognitionFieldSubType:(WCRecognitionFieldSubType)subType;


@end
