//
//  WCRecognitionCardModel.h
//  
//
//  Created by Howard.Lin on 13/12/5.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "WCRecognitionFieldModel.h"
#import "WCRecognitionImageDefine.h"

@interface WCRecognitionCardModel : NSObject
{
    @protected
     NSDate                 *createdTime_;
     NSDate                 *modifiedTime_;
     NSInteger              frontRecognitionLanguage_;
     NSInteger              backRecognitionLanguage_;
     NSString               *cardID_;
     NSMutableDictionary    *fieldModelArrayDictionary_;
     WCRecognitionImageType sourceImageType_;
}


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic, copy)     NSDate                 *createdTime;
@property (nonatomic, copy)     NSDate                 *modifiedTime;
@property (nonatomic, assign)   NSInteger              frontRecognitionLanguage;
@property (nonatomic, assign)   NSInteger              backRecognitionLanguage;
@property (nonatomic, readonly) NSMutableDictionary    *fieldModelArrayDictionary;
@property (nonatomic, copy)     NSString               *cardID;
@property (nonatomic, assign)   WCRecognitionImageType sourceImageType;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

/**
 *
 **/
- (void)addRecognitionFieldModel:(WCRecognitionFieldModel *)fieldModel;


/**
 *
 */
- (BOOL)insertWCRecognitionFieldModel:(WCRecognitionFieldModel *)recognitionFieldModel;


/**
 *
 */
- (NSInteger)fieldCountWithWCRecognitionFieldMainType:(WCRecognitionFieldMainType)fieldType;


/**
 *
 */
- (NSMutableArray *)recognitionFieldModelArrayWithType:(WCRecognitionFieldMainType)fieldMainType;


/**
 *
 */
- (WCRecognitionFieldModel *)recognitionFieldModelWithRecognitionFieldMainType:(WCRecognitionFieldMainType)mainType atIndex:(NSUInteger)fieldIndex;

@end
