//
//  CardRecognitionController.h
//
//
//  Created by Howard.Lin on 13/12/4.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "RecognitionOperation.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, CardRecognitionControllerTranslation)
{
    CardRecognitionControllerTranslation_Same,
    CardRecognitionControllerTranslation_TranditionalToSimple,
    CardRecognitionControllerTranslation_SimpleToTranditional
};

////////////////////////////////////////////////////////////////////////////////////////////////////

static NSString *const CardRecognitionController_SilentRecogRestCount = @"CardRecognitionController_SilentRecogRestCount";

////////////////////////////////////////////////////////////////////////////////////////////////////

@class CardRecognitionController;

@protocol CardRecognitionControllerDelegate <NSObject>

@required

- (void)cardRecognitionControllerStartAllRecognition:(CardRecognitionController *)cardRecognitionController;

- (void)cardRecognitionController:(CardRecognitionController *)cardRecognitionController
        didFinishAllRecogWithMode:(RecognitionOperationMode)recogMode;

- (WCCardModel *)cardModelWithCardRecognitionController:(CardRecognitionController *)cardRecognitionController
                                             recogImage:(UIImage *)recogImage
                                            recogSource:(WCRecogSourceModel *)recogSource
                                                  error:(NSError **)error;

@optional

- (UIImage *)resetImageBeforeRecognizing:(UIImage *)image
           withCardRecognitionController:(CardRecognitionController *)cardRecognitionController
                             recogSource:(WCRecogSourceModel *)recogSource;

- (UIImage *)resetImageBeforeSaving:(UIImage *)image
      withCardRecognitionController:(CardRecognitionController *)cardRecognitionController
                        recogSource:(WCRecogSourceModel *)recogSource;


- (void)cardRecognitionController:(CardRecognitionController *)cardRecognitionController
                  recogFrontImage:(UIImage *)recogFrontImage
                   recogBackImage:(UIImage *)recogBackImage
             resultFrontCardModel:(WCCardModel *)frontCardModel
              resultBackCardModel:(WCCardModel *)backCardModel
       ppRecognitionOperationMode:(RecognitionOperationMode)recognitionOperationMode
        frontCardRecognitionError:(NSError *)frontCardRecognitionError
         backCardRecognitionError:(NSError *)backCardRecognitionError;


- (void)cardRecognitionControllerDidRecogOneSource:(WCRecogSourceModel *)recogSource
                                        recogImage:(UIImage *)recogImage
                        ppRecognitionOperationMode:(RecognitionOperationMode)recognitionOperationMode
                                   resultCardModel:(WCCardModel *)cardModel
                                             error:(NSError *)error;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface CardRecognitionController : NSObject
{
    @protected
     id<CardRecognitionControllerDelegate>   delegate_;
     NSError                                 *lastRecognitionError_;
     NSMutableDictionary                     *recognitionCountDictionary_;
     NSMutableArray                          *normalRecogSourceArray_;
     NSMutableArray                          *silentRecogSourceArray_;
     NSOperationQueue                        *recognitionQueue_;
     NSUInteger                              totalSource_;
    
     WCCardModel                             *lastRecognitionCardModel_;
     RecognitionOperationMode                lastRecognitionOperationModel_;
     WCRecogSourceModel                      *lastWCRecogSourceModel_;
     UIImage                                 *lastRecognitionImage_;
    
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (atomic,assign) id<CardRecognitionControllerDelegate> delegate;
@property (nonatomic,assign) NSUInteger                            totalSource;


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance methods

// start recognition
- (void)startRecogWithMode:(RecognitionOperationMode)recogMode sources:(NSMutableArray *)recogSourceArray;

// suspend or resume silent recognition
- (void)suspendSilentRecognitionProcess:(BOOL)suspend;

// cancel silent recognition
- (void)cancelSilentRecognitionProcess;

// get silent recognition count
- (NSInteger)silentRecognitionCount;

- (NSUInteger)silentRecognitionCountForUserCount;

- (BOOL)operationWorking;

- (void)minusRecognitionCountForCardID:(NSString *)cardId;

- (void)removeAllLocalRecognitionAssets;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

+ (instancetype)shareRecognitionInstance;

/// 從WCRecogSourceModel中取出image
+ (UIImage *)imageFromRecogSource:(WCRecogSourceModel *)recogSource lightImage:(BOOL)lightImage;
@end
