//
//  WCGroupViewDelegate.h
//  ADAL
//
//  Created by sanhue on 2018/2/22.
//

#import <Foundation/Foundation.h>

@class WCGroupView;
@class WCGroupTableViewCell;
@class WCGroupModel;


@protocol WCGroupViewDelegate <NSObject>
@optional


/**
 * reload完成通知App
 * @param groupView instance
 */
- (void)didReloadDataWithGroupView:(nonnull WCGroupView *)groupView;


/**
 *  建立完cell後，通知上層, 客制化cell從這邊處理
 *
 *  @param groupView groupView object
 *  @param cell      完成的cell
 */
- (void)groupView:(nonnull WCGroupView *)groupView didLoadCell:(nonnull WCGroupTableViewCell*)cell dataObject:(nonnull WCGroupModel *)dataObject;

/**
 * 通知展開cell
 * @param groupView instance
 * @param cell 被點選的cell
 */
- (void)groupView:(nonnull WCGroupView *)groupView didExpandCell:(nonnull WCGroupTableViewCell *)cell;

/**
 * 通知關閉cell
 * @param groupView instance
 * @param cell 被點選的cell
 */
- (void)groupView:(nonnull WCGroupView *)groupView didCollapeCell:(nonnull WCGroupTableViewCell *)cell;

/**
 * 通知點選cell
 * @param groupView instance
 * @param cell 被點選的cell
 */
- (void)groupView:(nonnull WCGroupView *)groupView didClickCell:(nonnull WCGroupTableViewCell *)cell;


/**
 * 通知釘選群組，style是WCGroupViewStyle_NameWithCountAndPinMark時才會傳出
 * @param groupView instance
 * @param cell 被點選的cell
 * @param isPinned 是否要釘選
 */
- (void)groupView:(nonnull WCGroupView *)groupView cell:(nonnull WCGroupTableViewCell *)cell isPinned:(BOOL)isPinned;

@end
