//
//  WCContactEditSectionController.h
//
//  Created by Howard.Lin on 13/9/27.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPSectionController.h"
#import "ContactEditDataModel.h"
#import "ContactDataExchangeProtocol.h"
#import "PPRowModel+Contact.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCContactEditSectionController : PPSectionController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,retain)   ContactEditDataModel *dataModel;
@property (nonatomic,retain)   NSArray              *noteFieldArray;
@property (nonatomic,retain)   NSArray              *systemCategoryArray; //The array of ContactDataExchangeModel;
@property (nonatomic,readonly) NSMutableArray       *extraSubTypeArray;
@property (nonatomic,assign)   BOOL                 showNamePhonetic;
@property (nonatomic,assign)   BOOL                 showCompanyPhonetic;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

/**
 * To check if upperLimit is archived, and save or not
 * @section: The section you want to check
 * @param searching If searhing is NO, the sectionModelsForDefault_ is to check
 * @return: If return YES, the upperLimit is archived and to remove "MLS_Addxxx" rowModel
 */
- (BOOL)checkArchivingUpperLimitAndRemoveRowModelForSection:(NSUInteger)section forSearching:(BOOL)searching;


/**
 * To change text of RowModel(PPRowModel)
 * @param text The text is to set
 * @param indexPath The indexPath of RowModel
 * @return: If return YES, The text has been changed
 */
- (BOOL)changeRowModelText:(NSString *)text
               atIndexPath:(NSIndexPath *)indexPath;

/**
 * To check "MLS_Addxxx" rowModel which exists in section
 * @param searching If searhing is NO, the sectionModelsForDefault_ is to check invalid
 * @return: If return YES, checking and saving of rowModel is sucuessful.
 */
- (BOOL)checkIllegalAndSaveRowModelInSection:(NSUInteger)section forSearching:(BOOL)searching;


/**
 * To delete RowModel(PPRowModel) at indexPath
 * @param indexPath The indexPath of RowModel
 * @param searching If searhing is NO, the sectionModelsForDefault_ is to delete a element
 * @return: If return YES, The rowModel is deleted
 */
- (BOOL)deleteRowModelAtIndexPath:(NSIndexPath *)indexPath
                     forSearching:(BOOL)searching;


/**
 * To delete sectionModel(PPContactSetionModel) at section
 * @param section The section of SectionModel
 * @param searching If searhing is NO, the sectionModelsForDefault_ is to delete a element
 * @return: If return YES, The sectionModel is deleted
 */
- (BOOL)deleteSectionModelAtIndex:(NSUInteger)section
                     forSearching:(BOOL)searching;


/**
 * To expand the content of rowModel in sectionModel which has contactMainType
 * @param title The title is to be added to rowModel
 * @param contactMainType The contactMainType of sectionModel
 * @param searching If searhing is NO, the sectionModelsForDefault_ is to expand
 * @return: If return YES, expanding the content of rowModel in sectionModels which has contactMainType is sucuessful.
 */
- (BOOL)expandRowModelFieldInPPContanctSectionWithTitle:(NSString *)title
                                      ppContactMainType:(PPContactMainType)contactMainType
                                           forSearching:(BOOL)searching;

/**
 * To insert the sectionModel to sectionModelsForDefault_ or sectionModelsForSearching_
 * @param searching If searhing is NO, the sectionModelsForDefault_ is to insert
 * @return: If return YES, inserting the sectionModel is sucuessful.
 */
- (BOOL)insertNewSectionModelForPPContactMainType:(PPContactMainType)contactMainType
                                     forSearching:(BOOL)searching;


/**
 * To get PPContactMainType form sectionModel which exists in section
 * @param section The section of sectionModel
 * @return: The PPContactMainType of sectionModel which exists in section
 */
- (PPContactMainType)contactMainTypeInSection:(NSUInteger)section
                                 forSearching:(BOOL)searching;

/**
 *  To get defaultContactSectionModel is accroding to PPContactMainType
 *
 *  @param contactMainType The contactMainType of sectionModel you want to combine
 *
 *  @return The ppContactSectionModel with contactMainType
 */
- (PPContactSectionModel *)defaultContactSectionModelForContactMainType:(PPContactMainType)contactMainType;


/**
 * To insert the rowModel in sectionModel from sectionModelsForDefault_ or sectionModelsForSearching_
 * @param section The section of sectionModel
 * @param searching If searhing is NO, the sectionModelsForDefault_ is to insert
 * @return: If return indexPath which is not equal to nil, and it's a last rowModel location .
 */
- (NSIndexPath *)indexPathForinsertingRowModelAtSection:(NSUInteger)section forSearching:(BOOL)searching;


/**
 * To clear ImageRectData which contactieldSource is equal to parameter contactFieldSource
 * @param searching If searhing is NO, the sectionModelsForDefault_ is to use
 */
- (void)clearImageRectDataWithContactFieldSource:(PPContactFieldSource)contactFieldSource searching:(BOOL)searching;


/**
 * To clear rowModel which contactieldSource is equal to parameter contactFieldSource
 * @param searching If searhing is NO, the sectionModelsForDefault_ is to use
 */
- (void)clearRowModelWithContactFieldSource:(PPContactFieldSource)contactFieldSource searching:(BOOL)searching;


/**
 * To set a default dataModel providing all data request for thie class
 * @param dataModel The dataModel you want to set
 * @param contactMainTypeArray The contactMainType of sectionModel you want to combine
 * @param searching If searhing is NO, the sectionModelsForDefault_ is to save default data
 */
- (void)defaultSectionDatasWithDataModel:(ContactEditDataModel *)dataModel
                  ppContactMainTypeArray:(NSArray *)contactMainTypeArray
                            forSearching:(BOOL)searching;


/**
 * To dump data from sectionModelsForDefault_ or sectionModelsForSearching_
 * @param searching If searhing is NO, the sectionModelsForDefault_ is to dump
 */
- (void)dumpDataForSearching:(BOOL)searching;


/**
 * To fetch fieldDictionary to sectionModel
 * @param fieldDictionary The source data
 * @param orders The order of cell
 * @param searching If searhing is NO, the sectionModelsForDefault_ is to use
 */
- (void)fetchFieldDictionary:(NSDictionary *)fieldDictionary
                      orders:(NSArray *)orders
 toSectionModelsForSearching:(BOOL)searching;

/**
 *  判斷群組是否有效
 *
 *  @return True 有效
 */
- (BOOL)validGroup;


/**
 *  第一個欄位是否為空姓名欄位
 *
 *  @return YES 空
 */
- (BOOL)emptyNameFieldAtFirst;


/**
 *  啟用系統類別
 *  @param orders 順序
 *
 *  @param enable 啟動
 */
- (void)enableSystemCategory:(BOOL)enable orders:(NSArray *)orders;



/**
 檢查欄位是否合法

 @return YES, 欄位合法
 */
- (BOOL)legalDataText;


/**
 第一筆不合法資料 indexPath

 @return indexPath, 若為nil 代表合法
 */
- (NSIndexPath *)firstIllegalDataForIndexPath;

@end
