//
//  WCContactEditFieldSectionController.h
//
//  Created by Howard.Lin on 13/10/1.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPSectionController.h"
#import "ContactEditFieldDataModel.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCContactEditFieldSectionController : PPSectionController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,retain) ContactEditFieldDataModel *dataModel;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

/**
 * To return indexPath of RowModel, the title of which is equpal to title
 * @param title The search title
 * @param searching If searching is YES, sectionModelsForDefault is used.
 * @return: The indexPath of RowModel, the title of which is equpal to title
 */
- (NSIndexPath *)indexPathForTitle:(NSString *)title forSearching:(BOOL)searching;


/**
 * To return the correct sectionModel
 * @param contactMainType The section you want to show
 * @return: The corret PPContactSectionModel
 */
- (PPContactSectionModel *)contactSetionModelForPPContactMainType:(PPContactMainType)contactMainType;


/**
 * To return the correct sectionModels
 * @param dataModel The dataModel is to generate data
 * @param contactMainTypeArray The section you want to show
 * @param filterContactSubTypeArray The SubType you dont want to show
 * @return: the correct sectionModels
 */
+ (NSMutableArray *)sectionModelArrayForDataModel:(ContactEditFieldDataModel *)dataModel
                           ppContactMainTypeArray:(NSArray *)contactMainTypeArray
                      filterPPContactSubTypeArray:(NSArray *)filterContactSubTypeArray;

@end
