//
//  PPHeadImageNameTabelViewCell.h
//  
//
//  Created by Howard on 2015/6/30.
//
//

#import "PPTableViewCell.h"
#import "PPButton.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, PPHeadImageNameTabelViewCellButtonTag)
{
    PPHeadImageNameTabelViewCellButtonTag_None,
    PPHeadImageNameTabelViewCellButtonTag_AddFrontCard,
    PPHeadImageNameTabelViewCellButtonTag_AddBackCard,
    PPHeadImageNameTabelViewCellButtonTag_Flip,
    PPHeadImageNameTabelViewCellButtonTag_ClickHeadImage,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, PPHeadImageNameTabelViewCellGuideIndex)
{
    PPHeadImageNameTabelViewCellGuideIndex_AddFrontCard = 2000,
    PPHeadImageNameTabelViewCellGuideIndex_AddBackCard,
    PPHeadImageNameTabelViewCellGuideIndex_Flip,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPImageTabelViewCellImageSource

@class PPHeadImageNameTabelViewCell;

@protocol PPImageTabelViewCellImageSource <NSObject>

@optional
- (UIImage *)headImage;
- (BOOL)existFrontCardImage;
- (BOOL)existRearCardImage;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPHeadImageNameTableViewCellDelegate 

@protocol PPHeadImageNameTableViewCellDelegate <NSObject>

@optional

- (void)ppHeadImageNameTableViewCell:(PPHeadImageNameTabelViewCell *)headImageNameTabelViewCell
                            ppButton:(PPButton *)ppButton
                        controlEvent:(UIControlEvents)controlEvent;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPHeadImageNameTabelViewCell

@interface PPHeadImageNameTabelViewCell : UITableViewCell

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,assign) id<PPHeadImageNameTableViewCellDelegate> delegate;
@property (nonatomic,retain) UIImage                                  *defaulHeadImage;
@property (nonatomic,assign) UIEdgeInsets                             headImageButtonEdgeInsets;
@property (nonatomic,assign) UIEdgeInsets                             addOrFlipCardButtonEdgeInsets;
@property (nonatomic,retain,readonly) PPButton                        *addOrFlipContactCardButton;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

- (void)fetchImageWithObject:(id<PPImageTabelViewCellImageSource>)object;
- (void)reuse;
- (UITextField *)textFieldForTag:(NSUInteger)tag;
- (void)showDefaultHeadImage;

@end
