//
//  PPDateSectionController+ParameterDefine.h
//  
//
//  Created by Howard on 2017/2/9.
//
//

#ifndef PPDateSectionController_ParameterDefine_h
#define PPDateSectionController_ParameterDefine_h

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Error code Define

typedef NS_ENUM(NSUInteger,PPDateSectionControllerErrorCode)
{
    PPDateSectionControllerErrorCode_Over_SmallMonthDayCount,
    PPDateSectionControllerErrorCode_Over_LeapMonthDayCount,
    PPDateSectionControllerErrorCode_Over_FebruaryDayCount
};

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Component Define

typedef NS_ENUM(NSUInteger,PPDateSectionControllerComponent)
{
    PPDateSectionControllerComponent_Year,  // 1991-Current
    PPDateSectionControllerComponent_Month,
    PPDateSectionControllerComponent_Day,
};





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Day Count Define

static NSUInteger  const PDSC_MonthCount  = 12;

static NSUInteger  const PDSC_LargeMonthDayCount = 31;
static NSUInteger  const PDSC_SmallMonthDayCount = 30;
static NSUInteger  const PDSC_LeapMonthDayCount = 29;
static NSUInteger  const PDSC_FebruaryDayCount = 28;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Year Custom Define

static NSString *  const PDSC_YearCustomToken  = @"----";
static NSString *  const PDSC_MinimumDate  = @"1900/1/1";
static NSString *  const PDSC_MaximumDate  = @"2100/12/31";


#endif /* PPDateSectionController_ParameterDefine_h */
