//
//  ContactInfoDataModel.h
//
//  Created by Howard.Lin on 13/10/16.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "PPContactSectionModel.h"
#import "PPContactAddressFormatDefine.h"
#import "PPContactNameOrderDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface ContactInfoDataModel : NSObject

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method For Inheriting

/*
 * To creating ppContactSectionModel by AddressContactDataExchangeModels
 * @param contactDataExchangeModels: The contactDataExchangeModels is [NSArray arrayWithObjects: ContactDataExchangeModel,ContactDataExchangeModel,nil]
 * @param frontCardBCRRecognitionLanguage: The front card recognition Languages (see namecard.h)
 * @param backCardBCRRecognitionLanguage: The back card recognition Languages (see namecard.h)
 * @return: The ppContactSectionModel is created by Addressfields
 */
+ (PPContactSectionModel *)ppContactSectionModelForParsingAddressContactDataExchangeModels:(NSArray *)contactDataExchangeModels
                                                           frontCardBCRRecognitionLanguage:(NSUInteger)frontCardBCRRecognitionLanguage
                                                            backCardBCRRecognitionLanguage:(NSUInteger)backCardBCRRecognitionLanguage;


/*
 * To creating ppContactSectionModel by CompanyContactDataExchangeModels
 * @param contactDataExchangeModels: The contactDataExchangeModels is [NSArray arrayWithObjects: ContactDataExchangeModel,ContactDataExchangeModel,nil]
 * @param showPhonetic: To show Phonetic or not
 * @return: The ppContactSectionModel is created by companyInfofields
 */
+ (PPContactSectionModel *)ppContactSectionModelForParsingCompanyContactDataExchangeModels:(NSArray *)contactDataExchangeModels
                                                                              showPhonetic:(BOOL)showPhonetic;


/*
 * To creating ppContactSectionModel by GroupContactDataExchangeModels
 * @param contactDataExchangeModels: The contactDataExchangeModels is [NSArray arrayWithObjects: ContactDataExchangeModel,ContactDataExchangeModel,nil]
 * @return: The ppContactSectionModel is created by Group
 */
+ (PPContactSectionModel *)ppContactSectionModelForParsingGroupContactDataExchangeModels:(NSArray *)contactDataExchangeModels;



/**
 *  解析可檢視帳號欄位資料
 *
 *  @param contactDataExchangeModels 帳號來源資料
 *
 *  @return 解析後帳號欄位資料
 */
+ (PPContactSectionModel *)ppContactSectionModelForParsingVisibleAccountContactDataExchangeModels:(NSArray *)contactDataExchangeModels;


/*
 * To creating ppContactSectionModel by Namefields
 * @param contactDataExchangeModels The field is [NSArray arrayWithObjects: ContactDataExchangeModel,ContactDataExchangeModel,nil]
 * @param salutation 由外部指定稱謂
 * @param easterNameOrder: The easter name order.
 * @param westernNameOrder: The western name order.
 * @param showPhonetic: To show Phonetic or not
 * @return: The ppContactSectionModel is created by Namefields
 */
+ (PPContactSectionModel *)ppContactSectionModelForParsingNameContactDataExchangeModels:(NSArray *)contactDataExchangeModels
                                                                             salutation:(NSString*)salutation
                                                                        easterNameOrder:(PPContactNameOrder)easterNameOrder
                                                                       westernNameOrder:(PPContactNameOrder)westernNameOrder
                                                                           showPhonetic:(BOOL)showPhonetic;

/*
 * To creating ppContactSectionModel by fields and contactMainType
 * @param fields: The field is [NSArray arrayWithObjects: ContactDataExchangeModel,ContactDataExchangeModel,nil]
 * @param contactMainType: The contactMainType for creating ppContactSectionModel
 * @return: The ppContactSectionModel is created by fields and contactMainType
 */
+ (PPContactSectionModel *)ppContactSectionModelForParsingNormalContactDataExchangeModels:(NSArray *)contactDataExchangeModels
                                                                        ppContactMainType:(PPContactMainType)contactMainType;

+ (PPContactSectionModel *)ppContactSectionModelForParsingSalesforceCompanyDataExchangeModels:(NSArray *)contactDataExchangeModels;

+ (PPContactSectionModel *)ppContactSectionModelForParsingSalesforceStatusDataExchangeModels:(NSArray *)contactDataExchangeModels;


@end
