//
//  ContactEditViewDataSource.h
//  
//
//  Created by Howard on 2016/11/22.
//
//

#import <Foundation/Foundation.h>

@class ContactEditView;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ContactEditViewDataSource

@protocol ContactEditViewDataSource <NSObject>

@required

/**
 * Asks the data source to return the number of sections in the contactEditTableView
 * @param contactEditView An object representing the table view requesting this information.
 * @return: The number of sections in contactEditTableView
 */
- (NSInteger)numberOfSectionsInContactEditView:(ContactEditView *)contactEditView;


/**
 * Tells the data source to return the number of rows in a given section of a table view
 * @param contactEditView The table-view object requesting this information
 * @param section An index number identifying a section in tableView
 * @return: The number of rows in section
 */
- (NSInteger)contactEditView:(ContactEditView *)contactEditView numberOfRowsInSection:(NSInteger)section;


/**
 * Asks the data source for a cell to insert in a particular location of the table view
 * @param contactEditView A contactEditView object requesting the cell
 * @param indexPath An index path locating a row in tableView
 * @return: An object inheriting from UITableViewCell that the table view can use for the specified row
 */
- (UITableViewCell *)contactEditView:(ContactEditView *)contactEditView cellForRowAtIndexPath:(NSIndexPath *)indexPath;


/**
 * Asks the data source to commit the insertion or deletion of a specified row in the receiver
 * @param contactEditView The contactEditTableView of ContactEditView object requesting the insertion or deletion.
 * @param editingStyle The cell editing style corresponding to a insertion or deletion requested for the row specified by indexPath
 * @param indexPath An index path locating the row in contactEditTableView
 */
- (void)contactEditView:(ContactEditView *)contactEditView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath;

@end
