//
//  ContactEditFieldView.h
//
//  Created by Howard.Lin on 13/10/1.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "PPTableView.h"
#import "ContactTextFieldTableViewCell.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ContactEditFieldViewDataSource

@class ContactEditFieldView;

@protocol ContactEditFieldViewDataSource <NSObject>

@required

/**
 * Asks the data source to return the number of sections in the editFieldTableView
 * @param contactEditFieldView An object representing the table view requesting this information.
 * @return: The number of sections in editFieldTableView
 */
 - (NSInteger)numberOfSectionsInContactEditFieldView:(ContactEditFieldView *)contactEditFieldView;


/**
 * Tells the data source to return the number of rows in a given section of a table view
 * @param contactEditFieldView The table-view object requesting this information
 * @param section An index number identifying a section in tableView
 * @return: The number of rows in section
 */
 - (NSInteger)contactEditFieldView:(ContactEditFieldView *)contactEditFieldView
             numberOfRowsInSection:(NSInteger)section;


/**
 * Asks the data source for a cell to insert in a particular location of the table view
 * @param contactEditFieldView A contactEditFieldView object requesting the cell
 * @param indexPath An index path locating a row in tableView
 * @return: An object inheriting from UITableViewCell that the table view can use for the specified row
 */
- (UITableViewCell *)contactEditFieldView:(ContactEditFieldView *)contactEditFieldView
                            cellForRowAtIndexPath:(NSIndexPath *)indexPath;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ContactEditFieldViewDelegate

@protocol ContactEditFieldViewDelegate <NSObject>

@required

/**
 * Tells the delegate that the specified row is now selected.
 * @param contactEditFieldView A contactEditFieldView object informing the delegate about the new row selection
 * @param indexPath An index path locating the new selected row in editFieldTableView
 */
 - (void)contactEditFieldView:(ContactEditFieldView *)contactEditFieldView didSelectRowAtIndexPath:(NSIndexPath *)indexPath;

/**
 * Tells the delegate that text of textfield has changed
 * @param textFieldTableViewCell The textfield of textFieldTableViewCell for which an editing session began
 * @param indexPath An index path locating the new selected row in contactEditTableView
 */
- (void)contactEditFieldView:(ContactEditFieldView *)contactEditFieldView ppTextFieldTableViewCellDidChanged:(PPTextFieldTableViewCell *)textFieldTableViewCell atIndexPath:(NSIndexPath *)indexPath;


@end




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ContactEditFieldView

@interface ContactEditFieldView : UIView <PPTextFieldTableViewCellDelegate,UITableViewDataSource,UITableViewDelegate>

@property (nonatomic,assign)   id<ContactEditFieldViewDataSource> dataSource;
@property (nonatomic,assign)   id<ContactEditFieldViewDelegate>   delegate;
@property (nonatomic,readonly) PPTableView                        *editFieldTableView;

@end
