//
//  WCClipImageViewController.h
//  Pods
//
//  Created by sanhue on 2015/8/8.
//
//

#import <Foundation/Foundation.h>
#import "WCCardModel.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
/// 刮選影像模式按下完成的block
typedef void(^WCClipImageCompletion)(UIImage *clipedImage);

/// 手刮辨識模式按下辨識後的block
typedef void(^WCClipImageClipRecognizeCompletion)(CGRect clipedRect, NSInteger recogFiledID, NSInteger recogLanguageID, BOOL isBackSide);


////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCClipImageViewController : NSObject

/**
 * 從圖片clip一塊圖出來
 * @param viewController 從哪個view controller顯示
 * @param sourceImage 要被刮選的圖片
 * @param completion 完成後的處理
 */
+ (void)showClipImageFromViewController:(UIViewController *)viewController
                            sourceImage:(UIImage *)sourceImage
                             completion:(WCClipImageCompletion)completion;

/**
 * 顯示手刮辨識頁面
 * @param viewController 從哪個view controller顯示
 * @param frontCardImage 正面名片圖
 * @param backCardImage 反面名片圖
 * @param frontRecogLangID 正面預設的辨識語系
 * @param backRecogLangID 反面預設的辨識語系
 * @param recogLanguages 所有支援的辨識語系, array of WCKernelRecogLangModel
 * @param recogFields 所有支援的辨識欄位, array of WCKernelRecogTypeModel
 * @param showBackCardImage YES:預設顯示反面名片圖, NO:顯示正面
 * @param completion 完成後的處理
 */
+ (void)showClipRecognizeFromViewController:(UIViewController *)viewController
                             frontCardImage:(UIImage *)frontCardImage
                              backCardImage:(UIImage *)backCardImage
                           frontRecogLangID:(NSInteger)frontRecogLangID
                            backRecogLangID:(NSInteger)backRecogLangID
                             recogLanguages:(NSArray *)recogLanguages
                                recogFields:(NSArray *)recogFields
                          showBackCardImage:(BOOL)showBackCardImage
                                 completion:(WCClipImageClipRecognizeCompletion)completion;
@end
