//
//  CVCBaseCaptureController.h
//  Pods
//  要由WCCaptureViewController所控制的View當要增加新模式時繼承此Class即可
//  Created by Duke on 2015/4/7.
//
//

#import <UIKit/UIKit.h>
#import <AVFoundation/AVFoundation.h>
#import "PPBarView.h"
#import "PPButton.h"
#import "CVCOverlayView.h"
#import "CVCTargetView.h"
#import "WCCaptureViewController+TypeDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_OPTIONS(NSInteger, CVCBaseCaptureController_LayoutStyle)
{
    LayoutStyle_None = 0,
    LayoutStyle_AnimationStart,
    LayoutStyle_AnimationStop,
};

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCBaseCaptureModeDelegate methods

@class CVCBaseCaptureController;
@protocol WCBaseCaptureModeDelegate <NSObject>

@optional

/**
 *  當此Mode要求設定手電筒狀態
 */
- (void)captureController:(CVCBaseCaptureController *)captureController requestUpdateTorchState:(BOOL)state;

/**
 *  當此Mode要求設定閃光燈狀態
 */
- (void)captureController:(CVCBaseCaptureController *)captureController requestUpdateFlashState:(BOOL)state;

/**
 *  當此Mode要求設定影像優化狀態
 */
- (void)captureController:(CVCBaseCaptureController *)captureController requestUpdateImageEnhanceState:(BOOL)state;

/**
 *  當此Mode要求設定自動裁切狀態
 */
- (void)captureController:(CVCBaseCaptureController *)captureController requestUpdateAutoCropState:(BOOL)state;

/**
 *  當此Mode要求設定是否雙面模式
 */
- (void)captureController:(CVCBaseCaptureController *)captureController requestUpdateDoubleSideState:(BOOL)state;

/**
 *  當此Mode要求設定目前是否為正面
 */
- (void)captureController:(CVCBaseCaptureController *)captureController requestUpdateCaptureSideState:(WCCaptureViewController_CaptureSide)captureSide;

/**
 *  當此Mode要求顯示guide，需回傳guide要顯示的view
 */
- (UIView *)captureControllerRequestShowGuide:(CVCBaseCaptureController *)captureController;

/**
 *  當此Mode要求選取辨識語系
 */
- (void)captureControllerRequestSelectRecogLanguage:(CVCBaseCaptureController *)captureController;

/**
 *  當此Mode要求ViewController拍照
 */

- (void)captureControllerRequestCapture:(CVCBaseCaptureController *)captureController;

/**
 *  當此Mode要求cancel動作
 */
- (void)captureControllerRequestCancel:(CVCBaseCaptureController *)captureController;

/**
 *  當此Mode要求done動作
 */
- (void)captureControllerRequestDone:(CVCBaseCaptureController *)captureController;

/**
 *  當此Mode要求skip動作
 */
- (void)captureControllerRequestSkip:(CVCBaseCaptureController *)captureController;

/**
 *  當此Mode要求取得cameraView的大小
 */
- (CGSize)captureControllerRequestGetCameraViewSize:(CVCBaseCaptureController *)captureController;

/**
 *  當此Mode要求設定焦點
 *
 *  @param captureController instance of CVCBaseCaptureController
 *  @param focusPoint set focus point
 */
- (void)captureController:(CVCBaseCaptureController *)captureController requestSetFocusPoint:(CGPoint)focusPoint;

/**
 *  當此Mode送出QRCode字串
 *
 *  @param captureController instance of CVCBaseCaptureController
 *  @param qrCodeString QRCode字串
 */
- (void)captureController:(CVCBaseCaptureController*)captureController requestSendQRCodeString:(NSString *)qrCodeString;

/**
 *  顯示基座購買頁面
 *
 *  @param captureController instance of CVCBaseCaptureController
 */
- (void)captureControllerRequestShowDockPromotion:(CVCBaseCaptureController *)captureController;

/**
 *  切換到指定模式
 *
 *  @param captureController instance of CVCBaseCaptureController
 *  @param captureMode 指定模式
 */
- (void)captureController:(CVCBaseCaptureController*)captureController requestSwitchToMode:(WCCaptureViewController_CaptureMode)captureMode;

/**
 *  當此Mode需要log
 *
 *  @param captureController instance of CVCBaseCaptureController
 *  @param message message to log
 */
- (void)captureController:(CVCBaseCaptureController*)captureController requestLogMessage:(NSString *)message;

@end





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - CVCBaseCaptureController

@interface CVCBaseCaptureController : NSObject <PPButtonDelegate>

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Property - Views

/**
 *  覆蓋住CameraView的View，主要Camera上面的東西都放在這邊
 */
@property (nonatomic, retain) CVCOverlayView *overlayView;

/**
 *  下方拍照功能使用的ToolBar
 */
@property (nonatomic, retain) PPBarView *captureBar;

/**
 *  Toolbar以外可以看到目標影像的區域
 */
@property (nonatomic, retain) CVCTargetView *targetView;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Property - Other

@property (nonatomic ,assign) id<WCBaseCaptureModeDelegate> delegate;

/**
 *  overlayView的LayoutConstraint
 */
@property (nonatomic, retain) NSMutableArray *overlayViewLayoutConstraints;

/**
 *  此模式的相機對焦模式
 */
@property (nonatomic, assign) AVCaptureFocusMode focusMode;


/**
 *  subViews顯示方向
 */
@property (nonatomic, readonly) UIInterfaceOrientation interfaceOrientation;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Private Methods - Optional subview (繼承用，外部請勿直接呼叫)

/// 使用預設訊息顯示
- (void)addInfoLabelWithSuperView:(UIView *)superview;

/// 調整訊息顯示大小
- (void)setupInfoLabelLayoutConstraintsWithMaxSize:(CGSize)maxSize;

/// 永久更新訊息
- (void)updateInfoLabelLastingWithText:(NSString *)text;

/// 暫時更新訊息
- (void)updateInfoLabelTemporaryWithText:(NSString *)text;

/// 使用預設拍照數量顯示
- (void)addCaptureCountLabelWithSuperview:(UIView *)superview;

/// 更新拍照數量
- (void)updateCaptureCountLabelWithNumber:(NSInteger)count;





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance Methods - Guide

/**
 *  說明內容
 */
- (NSArray *)guideDataModelsWithClassName:(NSString *)className;


/**
 *  顯示說明
 */
- (void)manuallyShowGuide;





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance Methods - subview layout

/// 加入要使用的optional subview
- (void)addOptionalSubviews;

/**
 *  在CaptureViewController的didRotation階段設定subview
 */
- (void)setupSubviewsInterfaceOrientation:(UIInterfaceOrientation)orientation;

/**
 *  設定overlayView的LayoutConstraint
 *
 * @param layoutStyle - One of CVCBaseCaptureController_LayoutStyle
 */
- (void)setupOverlayViewLayoutConstraintWithStyle:(CVCBaseCaptureController_LayoutStyle)layoutStyle;

/**
 *  旋轉某個View
 *
 *  @param view 要旋轉的View
 */
- (void)rotateView:(UIView *)view;





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance Methods - subview content/status

/// Setup capture count
- (void)setupCaptureCount:(NSInteger)captureCount;

/// Setup capture side
- (void)setupCaptureSide:(WCCaptureViewController_CaptureSide)captureSide;

/// Setup flash state
- (void)setupFlashState:(BOOL)enableFlash;

/// Setup torch state
- (void)setupTorchState:(BOOL)enableTorch;

/// Setup image inhance state
- (void)setupImageEnhanceState:(BOOL)enableImageEnhance;

/// Setup image inhance state
- (void)setupAutoCropState:(BOOL)enableAutoCrop;

/// Setup double side state
- (void)setupDoubleSideState:(BOOL)enableDoubleSide;

/// Setup recog language state
- (void)setupRecogLanguageState:(NSString *)recogLanguage;

/// Setup auto detection state (for docking capture)
- (void)setupAutoDetectionState:(BOOL)enableAutoDetection;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance Methods - Flow action methods

/**
 *  當切換到此模式時
 */
- (void)actionWhenActive;

/**
 *  當切離開此模式時
 */
- (void)actionWhenDeactive;

/**
 *  當CameraView收到PreviewImage時
 *
 *  @param previewImage CameraView收到的PreviewImage
 */
- (void)actionWhenReceivePreviewImage:(UIImage *)previewImage;

/**
 *  當CameraView取得StillImage後的處理
 */
- (void)actionWhenGetStillImage;

/**
 *  跳過反面Capture
 */
- (void)actionWhenSkipBackSide;


@end
