//
//  WCImageBrowseBottomBarView.h
//
//  Created by Howard.Lin on 13/11/21.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPButton.h"
#import "PPBarView.h"
////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, WCImageBrowseBottomBarViewButtonTag)
{
    WCImageBrowseBottomBarViewButtonTag_Back,
    WCImageBrowseBottomBarViewButtonTag_CaptureBackCard,
    WCImageBrowseBottomBarViewButtonTag_NextCard,
    WCImageBrowseBottomBarViewButtonTag_Done,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@class WCImageBrowseBottomBarView;

@protocol WCImageBrowseBottomBarViewDelegate <NSObject>

@optional

- (void)ppBrowseImageBottomBarView:(WCImageBrowseBottomBarView *)browseImageBottomBarView
                          ppButton:(PPButton *)button
                      controlEvent:(UIControlEvents)controlEvent;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCImageBrowseBottomBarView : PPBarView <PPButtonDelegate>

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,assign)   id<WCImageBrowseBottomBarViewDelegate> delegate;
@property (nonatomic,readonly) PPButton                               *backButton;
@property (nonatomic,readonly) PPButton                               *captureBackCardButton;
@property (nonatomic,readonly) PPButton                               *doneButton;
@property (nonatomic,readonly) PPButton                               *nextCardButton;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

- (void)updateCaptureCountLabelWithNumber:(NSInteger)count;

@end
