//
//  PPCSVWriter.h
//  WorldCardMobile
//
//  Created by harry on 11-6-29.
//  Copyright 2009 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

#import <CoreFoundation/CFStringEncodingExt.h>

#import "PPCSVFileHeader.h"

typedef enum {
	KPPCSVWriterRet_Failed = 0,
	KPPCSVWriterRet_Success,
}PPCSVWriterRet;

typedef enum {
	KPPCSVWriterEncoding_ANSI = 1,
	KPPCSVWriterEncoding_UTF8,
    KPPCSVWriterEncoding_UTF16,
}PPCSVWriterEncoding;

@protocol PPCSVWriterDelegate <NSObject>

@required
- (PPCSVWriterRet) writerQueryHeader:(NSObject*)aDelegateUserData outputFileHeader:(PPCSVFileHeader**)aCSVFileHeader;
- (PPCSVWriterRet) writerQueryTitleDataArray:(NSObject*)aDelegateUserData outputContactData:(NSArray**)aTitleDataArray addDoubleQuotation:(BOOL*)bAddDoubleQuotationPtr;
- (PPCSVWriterRet) writerQueryItemDataArray:(NSObject*)aDelegateUserData contactIndex:(NSInteger)aContactIndex outputContactData:(NSArray**)aItemDataArray;
- (void) writerDidFinishWriting:(NSObject*)aDelegateUserData;

@optional
-(void) writerDidEncounterError:(NSObject*)aDelegateUserData errorMessage:(NSString*)aErrorMessage;

@end

@interface PPCSVWriter : NSObject
{
    NSString* _filePath;
    NSObject* _delegateUserData;
    PPCSVWriterEncoding _csvWriterEncoding;
    NSStringEncoding _stringEncoding;
    BOOL _willSendByEmail;
    
    id<PPCSVWriterDelegate> _delegate;

}

@property(nonatomic, assign) id<PPCSVWriterDelegate> _delegate;

//  Private Methods
- (void)pp_writeOneLineDataArrayToFile:(NSFileHandle*)aFileHandle withDataArray:(NSArray*)aDataArray withEncoding:(NSStringEncoding)aStringEncoding isAddNewLineAtEnd:(BOOL)bIsAddNewLineAtEnd isAddDoubleQuotation:(BOOL)bIsAddDoubleQuotation;

//  Public Methods
- (id)initWithDelegate:(id)aDelegate andDelegateUserData:(NSObject*)aUserData andFilePath:(NSString*)aFilePath andEncoding:(PPCSVWriterEncoding)aEncoding willSendByEmail:(BOOL)willSendByEmail;

- (BOOL) startWriting;

+ (CFStringEncoding)pp_getStringEncodingByCurrentSystemLanguage;
@end
