//
//  WCBackupRestoreFlowController.h
//  
//

#import <Foundation/Foundation.h>
#import "WCBackupRestoreFlowController+TypeDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

/// WCBackupRestoreFlowController
@interface WCBackupRestoreFlowController : NSObject


/**
 * 開始備份還原流程
 *
 * @param superViewController   啟動流程時所在的viewController
 * @param cloudKeyDictionary    所有網路空間需要用到的key
 * @param cloudSpaceTypeArray   指定可以使用的網路空間
 * @param baseStoreDirPath      資料的根目錄
 * @param excludeDirPatterns    不需備份的子目錄名稱字段（有包含這些字段的目錄名稱就不備份）
 * @param handleRestoreData     還原前的資料處理block，不需要還原的資料請在這裡清除。restoreTempDir為資料暫存目錄。
 * @param completion            通知結束的block。action代表操作行為，error == nil表示成功。
 */
+ (void)startWithSuperViewController:(UIViewController *)superViewController
                  cloudKeyDictionary:(NSDictionary *)cloudKeyDictionary
                 cloudSpaceTypeArray:(NSArray *)cloudSpaceTypeArray
                    baseStoreDirPath:(NSString *)baseStoreDirPath
                  excludeDirPatterns:(NSArray *)excludeDirPatterns
                   handleRestoreData:(BOOL (^)(NSString *restoreTempDir))handleRestoreData
                          completion:(void (^)(WCBackupRestoreFlowController_Action action, NSError *error))completion;

+ (NSDate *)lastBackupDate;
@end
