//
//  AdvanceSearchViewDelegate.h
//  Pods
//
//  Created by AndrewLai on 2018/3/2.
//

#import <Foundation/Foundation.h>

@class AdvanceSearchView;
@class ContactKeyboardToolBarView;
@class PPMultipleTextFieldButtonTableViewCell;
@class PPPhoneTextFieldTableViewCell;
@class PPTextFieldTableViewCell;
@class PPTextViewTableViewCell;
@class SearchPhoneTextFieldTableViewCell;
@class SearchPicklistChoiceTableViewCell;
@class PPButton;

////////////////////////////////////////////////////////////////////////////////////////////////////

@protocol AdvanceSearchViewDelegate <NSObject>

/**
 * Tells the delegate that the specified row is now selected
 * @param advanceSearchView A advanceSearchView object informing the delegate about the new row selection
 * @param indexPath An index path locating the new selected row in advanceSearchView
 */
- (void)advanceSearchView:(AdvanceSearchView *)advanceSearchView didSelectRowAtIndexPath:(NSIndexPath *)indexPath;


/**
 鍵盤上方bar按鈕觸發
 
 @param advanceSearchView 進階搜尋視圖
 @param contactEditKeyboardToolBarView 鍵盤上方視圖
 @param ppButton 按鈕
 @param controlEvent 按鈕事件
 */
- (void)advanceSearchView:(AdvanceSearchView *)advanceSearchView contactEditKeyboardToolBarView:(ContactKeyboardToolBarView *)contactEditKeyboardToolBarView ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent;


/**
 通知點選運算子按鈕
 
 @param advanceSearchView 進階搜尋視圖
 @param searchTableViewCell 點選運算子按鈕的tableViewCell
 */
- (void)advanceSearchView:(AdvanceSearchView *)advanceSearchView searchTableViewCellDidClickOperatorButton:(UITableViewCell *)searchTableViewCell;

////////////////////////////////////////////////////////////////////////////////////////////////////
@optional

/**
 通知點選cell中的下拉選單
 
 @param advanceSearchView 進階搜尋視圖
 @param picklistChoiceTableViewCell 下拉選單的cell
 */
- (void)advanceSearchView:(AdvanceSearchView *)advanceSearchView searchTableViewCellDidClickChoiceButton:(SearchPicklistChoiceTableViewCell *)picklistChoiceTableViewCell;

/**
 * Asks the delegate for the editing style of a row at a particular location in a advanceSearchView.
 * @param advanceSearchView An object representing the table view requesting this information.
 * @param indexPath An index path locating the new selected row in advanceSearchView
 * @return: The UITableViewCellEditingStyle of selected row
 */
- (UITableViewCellEditingStyle)advanceSearchView:(AdvanceSearchView *)advanceSearchView editingStyleForRowAtIndexPath:(NSIndexPath *)indexPath;


/**
 * Asks the delegate for the height to use for a row in a specified location
 * @param advanceSearchView The advanceSearchView object requesting this information.
 * @param indexPath An index path that locates a row in advanceSearchTableView
 * @return: A nonnegative floating-point value that specifies the height (in points) that row should be
 */
- (CGFloat)advanceSearchView:(AdvanceSearchView *)advanceSearchView heightForRowAtIndexPath:(NSIndexPath *)indexPath;
- (CGFloat)advanceSearchView:(AdvanceSearchView *)advanceSearchView estimatedHeightForRowAtIndexPath:(NSIndexPath *)indexPath;


////////////////////////////////////////////////////////////////////////////////////////////////////
//MARK: Cell欄位通知
/**
 TextField is in tableViewCell did end editing
 
 @param advanceSearchView 委託者
 @param textFieldTableViewCell cell欄位
 @param indexPath 選項
 */
- (void)advanceSearchView:(AdvanceSearchView *)advanceSearchView ppTextFieldTableViewCellDidEndEditing:(PPTextFieldTableViewCell *)textFieldTableViewCell atIndexPath:(NSIndexPath *)indexPath;


/**
 * Tells the delegate that editing began for the specified text field
 * @param advanceSearchView A advanceSearchView object informing the delegate about the begin editing
 * @param textFieldTableViewCell The textfield of textFieldTableViewCell for which an editing session began
 * @param indexPath An index path locating the new selected row in advanceSearchTableView
 */
- (void)advanceSearchView:(AdvanceSearchView *)advanceSearchView ppTextFieldTableViewCellDidBeginEditing:(PPTextFieldTableViewCell *)textFieldTableViewCell atIndexPath:(NSIndexPath *)indexPath;


/**
 Phone TextField is in tableViewCell did end editing
 
 @param advanceSearchView 委託者
 @param phoneTextFieldTableViewCell cell欄位
 @param indexPath 選項
 */
- (void)advanceSearchView:(AdvanceSearchView *)advanceSearchView ppPhoneTextFieldTableViewCellDidEndEditing:(PPPhoneTextFieldTableViewCell *)phoneTextFieldTableViewCell atIndexPath:(NSIndexPath *)indexPath;

@end
