//
//  AdvanceSearchViewDataSource.h
//  Pods
//
//  Created by AndrewLai on 2018/3/2.
//

#import <Foundation/Foundation.h>

@class AdvanceSearchView;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - AdvanceSearchViewDataSource

@protocol AdvanceSearchViewDataSource <NSObject>

@required

/**
 * Asks the data source to return the number of sections in the advanceSearchView
 * @param advanceSearchView An object representing the table view requesting this information.
 * @return: The number of sections in advanceSearchTableView
 */
- (NSInteger)numberOfSectionsInAdvanceSearchView:(AdvanceSearchView *)advanceSearchView;


/**
 * Tells the data source to return the number of rows in a given section of a table view
 * @param advanceSearchView The table-view object requesting this information
 * @param section An index number identifying a section in tableView
 * @return: The number of rows in section
 */
- (NSInteger)advanceSearchView:(AdvanceSearchView *)advanceSearchView numberOfRowsInSection:(NSInteger)section;


/**
 * Asks the data source for a cell to insert in a particular location of the table view
 * @param advanceSearchView A advanceSearchView object requesting the cell
 * @param indexPath An index path locating a row in tableView
 * @return: An object inheriting from UITableViewCell that the table view can use for the specified row
 */
- (UITableViewCell *)advanceSearchView:(AdvanceSearchView *)advanceSearchView cellForRowAtIndexPath:(NSIndexPath *)indexPath;


/**
 * Asks the data source to commit the insertion or deletion of a specified row in the receiver
 * @param advanceSearchView The advanceSearchTableView of AdvanceSearchView object requesting the insertion or deletion.
 * @param editingStyle The cell editing style corresponding to a insertion or deletion requested for the row specified by indexPath
 * @param indexPath An index path locating the row in advanceSearchTableView
 */
- (void)advanceSearchView:(AdvanceSearchView *)advanceSearchView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath;


/**
 * The table view uses a fixed font style for section header titles.
 * @param advanceSearchView The table-view object asking for the title.
 * @param section An index number identifying a section of tableView .
 * @return: A string to use as the title of the section header. If you return nil , the section will have no title.
 */
- (NSString *)advanceSearchView:(AdvanceSearchView *)advanceSearchView titleForHeaderInSection:(NSInteger)section;

@end
