//
//  WCABGroupViewController.h
//
//
//  Created by Howard.Lin on 2014/3/26.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#import "PPViewController.h"
#import <AddressBook/AddressBook.h>

// Define
#import "PPAppearance.h"

// Model
#import "WCABGroupModel.h"


////////////////////////////////////////////////////////////////////////////////////////////////////

@class WCABGroupViewController;

@protocol WCABGroupViewControllerDelegate <NSObject>

@required
- (void)abGroupViewController:(WCABGroupViewController *)abGroupViewController
        didSelectABGroupModel:(WCABGroupModel *)abGroupModel;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCABGroupViewController : PPViewController <PPAppearance>

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,assign) id<WCABGroupViewControllerDelegate> delegate;
@property (nonatomic,retain) id                                  userInfo;
@property (nonatomic,assign) BOOL                                checkMarkCell;
@property (nonatomic,retain) NSString                            *selectedGroupID;
@property (nonatomic,retain) NSString                            *selectedSourceID;

//上方工具列按鈕，highlighted狀態下的背景顏色
@property (nonatomic,retain) UIColor                             *navigationViewButtonHighlightedBackgroundColor PP_APPEARANCE_SELECTOR;

//列表視圖分隔線顏色
@property (nonatomic,retain) UIColor                             *tableViewSeparatorColor PP_APPEARANCE_SELECTOR;

//上方工具列按鈕，圖像的edgeInsets
@property (nonatomic,assign) UIEdgeInsets                        navigationViewButtonImageEdgeInsets PP_APPEARANCE_SELECTOR;

@property (nonatomic,copy) NSString                              *syncAccountName;

@end
