#ifndef PPCStringW_000000000
#define PPCStringW_000000000

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include "PPWString.h"
#include <deque>
#include "PPMem.h"


typedef class PPCStringW
{
public:
// Constructors

	// constructs empty PPCStringW
	PPCStringW();
	// copy constructor
	PPCStringW(PPCStringW& stringSrc);
	PPCStringW(PPWCHAR *lpsz);
	// from a single character
	PPCStringW(char *lpsz);

	PPWCHAR *GetBuffer();

	operator PPWCHAR*() const;
	
// Attributes & Operations
	// get data length
	int GetLength();
	// TRUE if zero length
	PPWCHAR GetAt(int nIndex);
	// return single character at zero-based index
	// overloaded assignment
	// ref-counted copy from another PPCStringW
	const PPCStringW& operator=(PPCStringW& stringSrc);
	// set string content to single character
	// copy string content from ANSI string (converts to TCHAR)
	const PPCStringW& operator=(PPWCHAR* lpsz);
	const PPCStringW& operator=(const char * lpsz);
	
	// concatenate from another PPCStringW
	const PPCStringW& operator+=(PPCStringW& string);

	const PPCStringW& operator+=(PPWCHAR* lpsz);
	const PPCStringW& operator+=(const char* lpsz);
	
	friend PPCStringW operator+(PPCStringW& string1,PPCStringW& string2);
	friend PPCStringW operator+(PPCStringW& string, PPWCHAR *lpsz);
	friend PPCStringW operator+(PPCStringW& str1,const char *lpsz);
	friend PPCStringW operator+(PPWCHAR * lpsz, PPCStringW& string);

	// string comparison

	// straight character comparison
	int Compare(PPWCHAR* lpsz);
	int Compare(const char *lpsz);
	int CompareNoCase(PPWCHAR* lpsz) ;
	int CompareNoCase(const char *lpsz) ;
	int Find(PPWCHAR *charPtr,int iStart);
	PPCStringW Left(int iLeftLen);
	PPCStringW Right( int nLen );
	PPCStringW Format(const PPWCHAR* format, ...);
	int Replace(PPWCHAR *lpszOld, PPWCHAR *lpszNew);
	int Replace(const char *lpszOld,const char *lpszNew);
	// compare ignoring case
	
	// NLS aware comparison, case sensitive
	//int Collate(LPCTSTR lpsz) const;
	// NLS aware comparison, case insensitive
	//int CollateNoCase(LPCTSTR lpsz) const;

	// simple sub-string extraction

	// return nCount characters starting at zero-based nFirst
	PPCStringW Mid(int nFirst, int nCount);
	// return all characters starting at zero-based nFirst
	//PPCStringA Mid(int nFirst) const;
	// return first nCount characters in string
	//PPCStringA Left(int nCount) const;
	// return nCount characters from end of string
	//PPCStringA Right(int nCount) const;

	//  characters from beginning that are also in passed string
	//PPCStringA SpanIncluding(LPCTSTR lpszCharSet) const;
	// characters from beginning that are not also in passed string
	//PPCStringA SpanExcluding(LPCTSTR lpszCharSet) const;

	// upper/lower/reverse conversion

	// NLS aware conversion to uppercase
	//void MakeUpper();
	// NLS aware conversion to lowercase
	//void MakeLower();
	// reverse string right-to-left
	//void MakeReverse();

	// trimming whitespace (either side)

	// remove whitespace starting from right edge
	//void TrimRight();
	// remove whitespace starting from left side
	//void TrimLeft();

	// trimming anything (either side)

	// remove continuous occurrences of chTarget starting from right
	//void TrimRight(TCHAR chTarget);
	// remove continuous occcurrences of characters in passed string,
	// starting from right
	void TrimRight(PPWCHAR* lpszTargets);
	void TrimRight(const char* lpszTargetList);
	// remove continuous occurrences of chTarget starting from left
	//void TrimLeft(TCHAR chTarget);
	// remove continuous occcurrences of characters in
	// passed string, starting from left
	void TrimLeft(PPWCHAR* lpszTargets);
	void TrimLeft(const char* lpszTargets);

	void MakeUpper();
	void MakeLower();

	int ToValue();
// Implementation
public:
	~PPCStringW();
	

protected:
	void Init();
	void AllocBaseMem();
	void Release();
	PPWCHAR *m_BufferPtr;
	int m_BufferSize;

	PPWString m_oneWStr;

	int findInStr(PPWCHAR oneChar,PPWCHAR *Buffer);
	int wcsicmp(const PPWCHAR * cs,const PPWCHAR * ct);
	PPWCHAR *wcsupr(PPWCHAR * str);
	PPWCHAR *wcslwr(PPWCHAR * str);
}PPCStringW;

typedef std::deque <PPCStringW*> PPCStringWPtrDQ;

//------------------------------------------------------------------------------
// PPCStringW

#endif
