//
//  PPTopButtonsActionSheet.h
//  WCMContactInfoViewController
//
//  Created by Andrew on 2015/6/8.
//  Copyright (c) 2015年 Andrew.Lai. All rights reserved.
//
//!! 需於viewDidLayoutSubViews重塞Frame，才會讓旋轉時畫面較為正常，不會露出底色

#import "PPCommentButton.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPTopButtonsActionSheet Protocol

@class PPTopButtonsActionSheet;
@protocol PPTopButtonsActionSheetDelegate <NSObject>

/**
 *  告知點選了其他功能按鈕清單(capabilityButtonArray)內的按鈕所記錄的Tag
 *
 *  @param ppTopButtonsActionSheet ppTopButtonsActionSheet
 *  @param buttonTag               目前點選的按鈕內所記錄tag
 */
- (void)ppTopButtonsActionSheet:(PPTopButtonsActionSheet *)ppTopButtonsActionSheet capabilityButtonSelectedTag:(NSInteger)buttonTag;

/**
 *  通知點選按鈕頁面的其他地方，進行關閉通知
 *
 *  @param ppTopButtonsActionSheet ppTopButtonsActionSheet
 */
- (void)ppTopButtonsActionSheetDidDismiss:(PPTopButtonsActionSheet *)ppTopButtonsActionSheet;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPTopButtonsActionSheet Interface

@interface PPTopButtonsActionSheet : UIView
@property (nonatomic,assign) id<PPTopButtonsActionSheetDelegate> delegate;
@property (nonatomic,assign) BOOL     isTopStyle;
@property (nonatomic,assign) CGFloat  buttonListViewAlpha;
@property (nonatomic,assign) CGFloat  minimumWidthOfButton;
@property (nonatomic,retain) NSArray *capabilityButtonArray;
@property (nonatomic,retain) UIColor *buttonListViewBackgroundColor;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

/**
 *  顯示其他功能按鈕清單，是否動畫顯示
 *
 *  @param superView 欲添加哪個頁面上方
 *  @param animated YES->動畫
 */
- (void)showFromSuperView:(UIView *)superView animated:(BOOL)animated;

/**
 *  關閉其他功能按鈕清單
 *
 *  @param animated YES->動畫
 */
- (void)hideWithAnimated:(BOOL)animated;


- (void)reLayoutSubViews;

@end
