//
//  PPTextFieldButtonView.h
//
//  Created by Howard.Lin on 2014/9/29.
//
//

#import <UIKit/UIKit.h>

#import "PPButton.h"
#import "CustomRectTextField.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@class PPTextFieldButtonView;

@protocol PPTextFieldButtonViewDelegate <NSObject>
@optional
- (BOOL)ppTextFieldButtonView:(PPTextFieldButtonView *)textFieldButtonView shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string;
- (void)ppTextFieldButtonViewDidBeginEditing:(PPTextFieldButtonView *)textFieldButtonView;
- (void)ppTextFieldButtonViewDidChanged:(PPTextFieldButtonView *)textFieldButtonView;
- (void)ppTextFieldButtonViewDidEndEditing:(PPTextFieldButtonView *)textFieldButtonView;
- (BOOL)ppTextFieldButtonViewShouldBeginEditing:(PPTextFieldButtonView *)textFieldButtonView;
- (BOOL)ppTextFieldButtonViewShouldClear:(PPTextFieldButtonView *)textFieldButtonView;
- (BOOL)ppTextFieldButtonViewShouldEndEditing:(PPTextFieldButtonView *)textFieldButtonView;
- (BOOL)ppTextFieldButtonViewShouldReturn:(PPTextFieldButtonView *)textFieldButtonView;
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent withPPTextFieldButtonView:(PPTextFieldButtonView *)textFieldButtonView;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPTextFieldButtonView : UIView <PPButtonDelegate,UITextFieldDelegate>

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property(nonatomic,assign)     id<PPTextFieldButtonViewDelegate> delegate;
@property(nonatomic,readonly)   CustomRectTextField               *textField;
@property(nonatomic,readonly)   PPButton                          *ppButtonDetail;
@property(nonatomic,assign)     NSUInteger                        maxLength;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Intended For Subclasses Method

- (void)textFieldDidBeginEditing;
- (void)textFieldDidChange;
- (void)textFieldDidEndEditing;
- (BOOL)textFieldShouldBeginEditing;
- (BOOL)textFieldShouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string;
- (BOOL)textFieldShouldClear;
- (BOOL)textFieldShouldEndEditing;
- (BOOL)textFieldShouldReturn;

@end
