//
//  PPTableViewCell.h
//  
//
//  Created by Mike on 13/5/15.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import <UIKit/UIKit.h>

////////////////////////////////////////////////////////////////////////////////////////////////////

#define PPTableViewCellDefaultHorizontalGap 6
#define PPTableViewCellDefaultVerticalGap   3

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPTableViewCell : UITableViewCell
{
@protected
	UIImageView             *backgroundImageView_;
    UITableViewCellStyle    style_;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,readonly) UIImageView          *backgroundImageView;
@property (nonatomic,readonly) UITableViewCellStyle style;
@property (nonatomic,assign) UIEdgeInsets         contentInsets UI_APPEARANCE_SELECTOR;

@property (nonatomic,assign) BOOL                 ignoreCustomLabelFrame UI_APPEARANCE_SELECTOR;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

- (id)initCustomStyleWithReuseIdentifier:(NSString *)reuseIdentifier;

/// 設定cell是否enable, subclass需override此api, 且需呼叫[super setEnable]
- (void)setEnable:(BOOL)enable;
@end
