//
//  PPStorageFileSelectNavigationBarView.h
// 
//
//  Created by Howard.Lin on 2014/3/18.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#import "PPNavigationBarView.h"
#import "PPButton.h"

////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, PPStorageFileSelectNavigationBarViewMode)
{
    PPStorageFileSelectNavigationBarViewMode_SingleChoiceBrowse,
    PPStorageFileSelectNavigationBarViewMode_MultiChoiceBrowse,
    PPStorageFileSelectNavigationBarViewMode_Edit,
};


typedef NS_ENUM(NSUInteger, PPStorageFileSelectNavigationBarViewButtonTag)
{
    PPStorageFileSelectNavigationBarViewButtonTag_Back,
    PPStorageFileSelectNavigationBarViewButtonTag_Done,
    PPStorageFileSelectNavigationBarViewButtonTag_Edit,
    PPStorageFileSelectNavigationBarViewButtonTag_Import,
};

////////////////////////////////////////////////////////////////////////////////

@class PPStorageFileSelectNavigationBarView;

@protocol PPStorageFileSelectNavigationBarViewDelegate <NSObject>

- (void)storageFileSelectNavigationBarView:(PPStorageFileSelectNavigationBarView *)storageFileSelectNavigationBarView
                             responderView:(UIView *)responderView
                              controlEvent:(UIControlEvents)controlEvent;

@end

////////////////////////////////////////////////////////////////////////////////

@interface PPStorageFileSelectNavigationBarView : PPNavigationBarView <PPButtonDelegate>

////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,assign)   id<PPStorageFileSelectNavigationBarViewDelegate> delegate;
@property (nonatomic,readonly) PPButton                                         *backorDoneButton;
@property (nonatomic,readonly) PPButton                                         *editButton;
@property (nonatomic,readonly) PPButton                                         *importButton;
@property (nonatomic,assign)   PPStorageFileSelectNavigationBarViewMode         mode;

@end
