//
//  PPSplitViewController.h
//  
//
//  Created by Mike on 13/5/13.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "PPViewController.h"
#import "PPInterfaceOrientationController.h"
#import "PPAppearance.h"

typedef NS_ENUM(NSInteger, PPSplitViewControllerDisplayMode)
{
    PPSplitViewControllerDisplayMode_None,
    PPSplitViewControllerDisplayMode_AllVisible,  // master, detail一起出現
    PPSplitViewControllerDisplayMode_Master,      // 顯示master
    PPSplitViewControllerDisplayMode_Detail,      // 顯示detail
};





////////////////////////////////////////////////////////////////////////////////////////////////////
@class PPSplitViewController;

@protocol PPSplitViewControllerDelegate <NSObject>

/**
 * 回傳預設的顯示模式，
 * @param splitViewController instance of split view controller
 * @param isPortrait YES: 回傳直式的顯示模式，否則回傳橫式的顯示模式
 * @return PPSplitViewControllerDisplayMode 目前方向的顯示模式
 */
- (PPSplitViewControllerDisplayMode)preferredDisplayModeForSplitViewController:(PPSplitViewController * _Nonnull )splitViewController isPortrait:(BOOL)isPortrait;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface PPSplitViewController : PPViewController <PPAppearance>

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

/// delegate
@property (nullable, nonatomic, assign) id <PPSplitViewControllerDelegate> delegate;

@property (nullable, nonatomic, retain) UIViewController *masterViewController;
@property (nullable, nonatomic, retain) UIViewController *detailViewController;

/// 目前的顯示模式
@property (nonatomic, assign, readonly) PPSplitViewControllerDisplayMode displayMode;

#pragma mark - styling

/// master的layout要是否要從topLayoutGuide下面開始, default NO;
@property (nonatomic, assign) BOOL layoutMasterBelowTopLayoutGuide;

/// detail的layout要是否要從topLayoutGuide下面開始, default NO;
@property (nonatomic, assign) BOOL layoutDetailBelowTopLayoutGuide;

/// 預設的mater寬度, 預設320
@property (nonatomic, assign) CGFloat preferredMasterWidth;

/// 預設背景色, defualt clearColor
@property (nonatomic, retain) UIColor * _Nullable defaultBackgroundColor PP_APPEARANCE_SELECTOR;

/// 預設的mater背景色，預設clear color
@property (nonatomic, retain) UIColor * _Nullable defaultMasterBackgroundColor PP_APPEARANCE_SELECTOR;

/// 預設的detail背景色，預設clear color
@property (nonatomic, retain) UIColor * _Nullable defaultDetailBackgroundColor PP_APPEARANCE_SELECTOR;

/// 預設的SplitBar寬度，預設 1
@property (nonatomic, assign) NSInteger defaultSplitBarWidth PP_APPEARANCE_SELECTOR;

/// 預設的SplitBar背景色，預設clear color
@property (nonatomic, retain) UIColor * _Nullable defaultSplitBarBackgroundColor PP_APPEARANCE_SELECTOR;

#pragma mark - methods

/// 鎖定左邊的ViewController
- (void)lockMasterViewController;

/// 解開左邊ViewController的鎖定
- (void)unlockMasterViewController;

/// 鎖定右邊的ViewController
- (void)lockDetailViewController;

/// 解開右邊ViewController的鎖定
- (void)unlockDetailViewController;


#pragma mark - class methods

/// 是否開啟鍵盤監測，default NO, 需在 split view controller init前設定
+ (void)enableMonitorKeyboard:(BOOL)enableMonitorKeyboard;


@end
