//
//  PPSettingsController.m
//

#import <Foundation/Foundation.h>

////////////////////////////////////////////////////////////////////////////////////////////////////
// Sample keys for integer value
#define PPSettingsController_Integer_kIntSample     @"PPSettingsController_Integer_kIntSample"    // 任意integer
#define PPSettingsController_Integer_kBoolSample    @"PPSettingsController_Integer_kBoolSample"   // Yes(1) or No(0)


////////////////////////////////////////////////////////////////////////////////////////////////////
// Sample keys for string value
#define PPSettingsController_String_kStringSample   @"PPSettingsController_String_kStringSample"  // 任意string

////////////////////////////////////////////////////////////////////////////////////////////////////
// Sample keys for NSData value
#define PPSettingsController_Data_kDataSample       @"PPSettingsController_Data_kDataSample"      // 任意nsdata

////////////////////////////////////////////////////////////////////////////////////////////////////
// Sample keys for NSArray value
#define PPSettingsController_Array_kArraySample     @"PPSettingsController_Array_kArraySample"    // 任意NSArray

////////////////////////////////////////////////////////////////////////////////////////////////////
// Sample keys for NSDictionary value
#define PPSettingsController_Dictionary_kDictionarySample     @"PPSettingsController_Dictionary_kDictionarySample"    // 任意NSDictionary

////////////////////////////////////////////////////////////////////////////////////////////////////

static const NSInteger PPSettingsController_UnsetIntValue = -99;

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface PPSettingsController : NSObject
{
    NSUserDefaults *_settings;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Public methods
- (id)initWithSuiteName:(NSString*)suiteName;

/**
 * Set NSArray value with key.
 *
 * @param arrayValue NSArray value to be saved.
 * @param key Key string.
 * @note 預設值專用，有值就不會再寫入！
 **/
- (void)setDefaultArrayValue:(NSArray *)arrayValue withKey:(NSString *)key;


/**
 * Set NSArray value with key.
 *
 * @param arrayValue NSArray value to be saved.
 * @param key Key string.
 **/
- (void)setArrayValue:(NSArray *)arrayValue withKey:(NSString *)key;


/**
 * Get NSArray value with key.
 *
 * @param key Key string.
 * @return Return nil if key not exist.
 **/
- (NSArray *)arrayValueWithKey:(NSString *)key;


/**
 * Set NSDictionary value with key.
 *
 * @param dictionaryValue NSDictionary value to be saved.
 * @param key Key string.
 * @note 預設值專用，有值就不會再寫入！
 **/
- (void)setDefaultDictionaryValue:(NSDictionary *)dictionaryValue withKey:(NSString *)key;


/**
 * Set NSDictionary value with key.
 *
 * @param dictionaryValue NSDictionary value to be saved.
 * @param key Key string.
 **/
- (void)setDictionaryValue:(NSDictionary *)dictionaryValue withKey:(NSString *)key;


/**
 * Get NSDictionary value with key.
 *
 * @param key Key string.
 * @return Return nil if key not exist.
 **/
- (NSDictionary *)dictionaryValueWithKey:(NSString *)key;


/**
 * Set NSData value with key.
 *
 * @param dataValue NSData value to be saved.
 * @param key Key string.
 * @note 預設值專用，有值就不會再寫入！
 **/
- (void)setDefaultDataValue:(NSData *)dataValue withKey:(NSString *)key;


/**
 * Set NSData value with key.
 *
 * @param dataValue NSData value to be saved.
 * @param key Key string.
 **/
- (void)setDataValue:(NSData *)dataValue withKey:(NSString *)key;


/**
 * Get NSData value with key.
 *
 * @param key Key string.
 * @return Return nil if key not exist.
 **/
- (NSData *)dataValueWithKey:(NSString *)key;

/**
 * Set integer value with key.
 *
 * @param integerValue Integer value to be saved.
 * @param key Key string.
 * @note 預設值專用，有值就不會再寫入！
 **/
- (void)setDefaultIntegerValue:(NSInteger)integerValue withKey:(NSString *)key;


/**
 * Set integer value with key.
 *
 * @param integerValue Integer value to be saved.
 * @param key Key string.
 **/
- (void)setIntegerValue:(NSInteger)integerValue withKey:(NSString *)key;


/**
 * Get integer value with key.
 *
 * @param key Key string.
 * @return Return PPSettingsController_UnsetIntValue if key not exist.
 **/
- (NSInteger)integerValueWithKey:(NSString *)key;


/**
 * Set string value with key.
 *
 * @param stringValue String value to be saved.
 * @param key Key string.
 * @note 預設值專用，有值就不會再寫入！
 **/
- (void)setDefaultStringValue:(NSString *)stringValue withKey:(NSString *)key;


/**
 * Set string value with key.
 *
 * @param stringValue String value to be saved.
 * @param key Key string.
 **/
- (void)setStringValue:(NSString *)stringValue withKey:(NSString *)key;


/**
 * Get string value with key.
 *
 * @param key Key string.
 * @return Return nil if key not exist.
 **/
- (NSString *)stringValueWithKey:(NSString *)key;


/**
 * Set NSDate value with key.
 *
 * @param dateValue NSDate value to be saved.
 * @param key Key string.
 * @note 預設值專用，有值就不會再寫入！
 **/
- (void)setDefaultDateValue:(NSDate *)dateValue withKey:(NSString *)key;


/**
 * Set NSDate value with key.
 *
 * @param dateValue NSDate value to be saved.
 * @param key Key string.
 **/
- (void)setDateValue:(NSDate *)dateValue withKey:(NSString *)key;


/**
 * Get NSDate value with key.
 *
 * @param key Key string.
 * @return Return nil if key not exist.
 **/
- (NSDate *)dateValueWithKey:(NSString *)key;


/**
 *  Set NSNumber value with key.
 *
 *  @param numberValue NSNumber value to be saved.
 *  @param key         Key string
 *  note: 預設值專用，有值就不會再寫入!
 */
- (void)setDefaultNumberValue:(NSNumber *)numberValue withKey:(NSString *)key;


/**
 *  Set NSNumber value with key.
 *
 *  @param numberValue NSNumber value to be saved.
 *  @param key         Key string
 */
- (void)setNumberValue:(NSNumber *)numberValue withKey:(NSString *)key;


/**
 *  Get NSNumber value with key.
 *
 *  @param key         Key string
 */
- (NSNumber *)numberValueWithKey:(NSString *)key;


/**
 * Remove value with key.
 *
 * @param key Key string.
 *
 **/
- (void)removeValueWithKey:(NSString *)key;




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Class methods

/**
 * Set NSArray value with key.
 *
 * @param arrayValue NSArray value to be saved.
 * @param key Key string.
 * @note 預設值專用，有值就不會再寫入！
 **/
+ (void)setDefaultArrayValue:(NSArray *)arrayValue withKey:(NSString *)key;


/**
 * Set NSArray value with key.
 *
 * @param arrayValue NSArray value to be saved.
 * @param key Key string.
 **/
+ (void)setArrayValue:(NSArray *)arrayValue withKey:(NSString *)key;


/**
 * Get NSArray value with key.
 *
 * @param key Key string.
 * @return Return nil if key not exist.
 **/
+ (NSArray *)arrayValueWithKey:(NSString *)key;


/**
 * Set NSDictionary value with key.
 *
 * @param dictionaryValue NSDictionary value to be saved.
 * @param key Key string.
 * @note 預設值專用，有值就不會再寫入！
 **/
+ (void)setDefaultDictionaryValue:(NSDictionary *)dictionaryValue withKey:(NSString *)key;


/**
 * Set NSDictionary value with key.
 *
 * @param dictionaryValue NSDictionary value to be saved.
 * @param key Key string.
 **/
+ (void)setDictionaryValue:(NSDictionary *)dictionaryValue withKey:(NSString *)key;


/**
 * Get NSDictionary value with key.
 *
 * @param key Key string.
 * @return Return nil if key not exist.
 **/
+ (NSDictionary *)dictionaryValueWithKey:(NSString *)key;


/**
 * Set NSData value with key.
 *
 * @param dataValue NSData value to be saved.
 * @param key Key string.
 * @note 預設值專用，有值就不會再寫入！
 **/
+ (void)setDefaultDataValue:(NSData *)dataValue withKey:(NSString *)key;


/**
 * Set NSData value with key.
 *
 * @param dataValue NSData value to be saved.
 * @param key Key string.
 **/
+ (void)setDataValue:(NSData *)dataValue withKey:(NSString *)key;


/**
 * Get NSData value with key.
 *
 * @param key Key string.
 * @return Return nil if key not exist.
 **/
+ (NSData *)dataValueWithKey:(NSString *)key;

/**
 * Set integer value with key.
 *
 * @param integerValue Integer value to be saved.
 * @param key Key string.
 * @note 預設值專用，有值就不會再寫入！
 **/
+ (void)setDefaultIntegerValue:(NSInteger)integerValue withKey:(NSString *)key;


/**
 * Set integer value with key.
 *
 * @param integerValue Integer value to be saved.
 * @param key Key string.
 **/
+ (void)setIntegerValue:(NSInteger)integerValue withKey:(NSString *)key;


/**
 * Get integer value with key.
 *
 * @param key Key string.
 * @return Return PPSettingsController_UnsetIntValue if key not exist.
 **/
+ (NSInteger)integerValueWithKey:(NSString *)key;


/**
 * Set string value with key.
 *
 * @param stringValue String value to be saved.
 * @param key Key string.
 * @note 預設值專用，有值就不會再寫入！
 **/
+ (void)setDefaultStringValue:(NSString *)stringValue withKey:(NSString *)key;


/**
 * Set string value with key.
 *
 * @param stringValue String value to be saved.
 * @param key Key string.
 **/
+ (void)setStringValue:(NSString *)stringValue withKey:(NSString *)key;


/**
 * Get string value with key.
 *
 * @param key Key string.
 * @return Return nil if key not exist.
 **/
+ (NSString *)stringValueWithKey:(NSString *)key;


/**
 * Set NSDate value with key.
 *
 * @param dateValue NSDate value to be saved.
 * @param key Key string.
 * @note 預設值專用，有值就不會再寫入！
 **/
+ (void)setDefaultDateValue:(NSDate *)dateValue withKey:(NSString *)key;


/**
 * Set NSDate value with key.
 *
 * @param dateValue NSDate value to be saved.
 * @param key Key string.
 **/
+ (void)setDateValue:(NSDate *)dateValue withKey:(NSString *)key;


/**
 * Get NSDate value with key.
 *
 * @param key Key string.
 * @return Return nil if key not exist.
 **/
+ (NSDate *)dateValueWithKey:(NSString *)key;


/**
 *  Set NSNumber value with key.
 *
 *  @param numberValue NSNumber value to be saved.
 *  @param key         Key string
 *  note: 預設值專用，有值就不會再寫入!
 */
+ (void)setDefaultNumberValue:(NSNumber *)numberValue withKey:(NSString *)key;


/**
 *  Set NSNumber value with key.
 *
 *  @param numberValue NSNumber value to be saved.
 *  @param key         Key string
 */
+ (void)setNumberValue:(NSNumber *)numberValue withKey:(NSString *)key;


/**
 *  Get NSNumber value with key.
 *
 *  @param key         Key string
 */
+ (NSNumber *)numberValueWithKey:(NSString *)key;


/**
 * Remove value with key.
 *
 * @param key Key string.
 *
 **/
+ (void)removeValueWithKey:(NSString *)key;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Class methods - All settings

/**
 * Get all setting keys and valudes
 **/
+ (NSDictionary *)allSettingsDict;


/**
 * Set all setting keys and valudes
 **/
+ (void)setAllSettingsWithDict:(NSDictionary *)dict;



/**
 * Remove all setting keys and valudes
 **/
+ (void)removeAllSettings;


@end
