//
//  PPSelectItemViewController.h
//  
//
//  Created by Mike.Shih on 13/9/24.
//  Copyright (c) 2013年 Mike.Shih. All rights reserved.
//

#import "PPButton.h"
#import "PPNavigationBarView.h"
#import "PPSectionController.h"
#import "PPTableView.h"
#import "PPTableViewCell.h"
#import "PPViewController.h"
#import "PPAppearance.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@class PPSelectItemViewController;
@protocol PPSelectItemViewControllerDelegate <NSObject>
@required
- (void)ppSelectItemViewController:(PPSelectItemViewController *)ppSelectItemViewController selectRowModel:(PPRowModel *)rowModel sectionModel:(PPSectionModel *)sectionModel;

@optional
- (UITableViewCell *)ppSelectItemViewController:(PPSelectItemViewController *)ppSelectItemViewController tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath;


/**
 *  客制化close的PPBarViewBlockModel，這個delegate實作為第一優先，沒有實作的話會看|closeItemModelForSelectItemViewController:|
 *
 *  @param ppSelectItemViewController PPSelectItemViewController
 *
 *  @return block model for button Close
 */
- (PPBarViewBlockModel *)closeBlockModelForSelectItemViewController:(PPSelectItemViewController *)ppSelectItemViewController;

/**
 *  客制化close的PPBarViewItemModel，這個delegate實作為第二優先，沒有實作的話會看|buttonCloseForSelectItemViewController:|
 *
 *  @param ppSelectItemViewController PPSelectItemViewController
 *
 *  @return item model for button Close
 */
- (PPBarViewItemModel *)closeItemModelForSelectItemViewController:(PPSelectItemViewController *)ppSelectItemViewController;

/**
 *  客制化buttonClose，這個delegate實作為最後
 *
 *  @param ppSelectItemViewController PPSelectItemViewController
 *
 *  @return PPButton for button Close
 */
- (PPButton *)buttonCloseForSelectItemViewController:(PPSelectItemViewController *)ppSelectItemViewController;


/**
 *  客制化close的PPBarViewBlockModel，這個delegate實作為第一優先，沒有實作的話會看|closeItemModelForSelectItemViewController:|
 *
 *  @param ppSelectItemViewController PPSelectItemViewController
 *
 *  @return block model for button Close
 */
- (PPBarViewBlockModel *)rightBlockModelForSelectItemViewController:(PPSelectItemViewController *)ppSelectItemViewController;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPSelectItemViewController : PPViewController
<
PPAppearance,
PPButtonDelegate,
UITableViewDataSource,
UITableViewDelegate
>

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

/// 設定委託對象
@property(nonatomic,assign)   id<PPSelectItemViewControllerDelegate>  delegate;

/**
 * 這個元件的sectionController, 資料要塞這邊
 * 預設值要在PPRowModel的object中塞@(YES)表示要勾選
 */
@property(nonatomic,readonly) PPSectionController                     *ppSectionController;

/// 是否隱藏返回鍵
@property(nonatomic,assign)   BOOL                                    hidenPPButtonBack;

/// 設定PPNavigationBarView的barViewStyle, default PPBarViewStyle_CenteredRelative
@property(nonatomic,assign)   PPBarViewStyle                          defaultBarViewStyle;

/// 是否使用PPNavigationBarView做navigation bar, default YES;
@property(nonatomic,assign)   BOOL                                    customNavigationBar;

/// 設定tab leView 背景色，default clearColor
@property(nonatomic,retain)   UIColor                                 *tableViewBackgroundColor PP_APPEARANCE_SELECTOR;


- (void)reloadTable;
@end
