//
//  PPSalesforceLoginView.h
//  Pods
//
//  Created by sanhue on 2016/9/19.
//
//

//#if TARGET_OS_IPHONE
//#import <UIKit/UIKit.h>
//#else
//#import <AppKit/AppKit.h>
//#endif

#import <WebKit/WebKit.h>

NS_ASSUME_NONNULL_BEGIN

// 需先在info.plist中設定以下設定才可以用
//
/* vvvvvvvv 複製以下程式碼，到info.plist貼上 vvvvvvvv
 
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE plist PUBLIC "-//Apple//DTD PLIST 1.0//EN" "http://www.apple.com/DTDs/PropertyList-1.0.dtd">
<plist version="1.0">
<dict>
<key>NSExceptionDomains</key>
<dict>
<key>force.com</key>
<dict>
<key>NSExceptionRequiresForwardSecrecy</key>
<false/>
<key>NSIncludesSubdomains</key>
<true/>
</dict>
<key>salesforce.com</key>
<dict>
<key>NSExceptionRequiresForwardSecrecy</key>
<false/>
<key>NSIncludesSubdomains</key>
<true/>
</dict>
</dict>
</dict>
</plist>
 
^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/

// !! salesforce後台需設定redirectURI為@"testsfdc:///mobilesdk/detect/oauth/done"
////////////////////////////////////////////////////////////////////////////////////////////////////
extern NSString * const kSFOAuthAccessToken;
extern NSString * const kSFOAuthIdentityUrl;
extern NSString * const kSFOAuthInstanceUrl;
extern NSString * const kSFOAuthIssuedAt;
extern NSString * const kSFOAuthRefreshToken;
extern NSString * const kSFOAuthScope;
extern NSString * const kSFOAuthSignature;
extern NSString * const kSFOAuthTokenType;
extern NSString * const kSFOAuthUserAccount;
extern NSString * const kSFOAuthExportMode;
extern NSString * const kSFOAuthFullName;
extern NSString * const kSFOAuthNickName;

////////////////////////////////////////////////////////////////////////////////////////////////////
extern NSString * const kPPSFOAuthErrorDomain;

/**
 @enum SFOAuthErrorDomain related error codes
 Constants used by SFOAuthCoordinator to indicate errors in the SFOAuth domain
 */
typedef NS_ENUM(NSInteger, kPPSFOAuthError)
{
    kPPSFOAuthErrorUnknown = 666,
    kPPSFOAuthErrorTimeout,
    kPPSFOAuthErrorMalformed,
    kPPSFOAuthErrorAccessDenied,              // end user denied authorization
    kPPSFOAuthErrorInvalidClientId,
    kPPSFOAuthErrorInvalidClientCredentials,  // client secret invalid
    kPPSFOAuthErrorInvalidGrant,              // expired access/refresh token, or IP restricted, or invalid login hours
    kPPSFOAuthErrorInvalidRequest,
    kPPSFOAuthErrorInactiveUser,
    kPPSFOAuthErrorInactiveOrg,
    kPPSFOAuthErrorRateLimitExceeded,
    kPPSFOAuthErrorUnsupportedResponseType,
    kPPSFOAuthErrorWrongVersion,              // credentials do not match current Connected App version in the org
    kPPSFOAuthErrorBrowserLaunchFailed,
    kPPSFOAuthErrorUnknownAdvancedAuthConfig,
    kPPSFOAuthErrorInvalidMDMConfiguration,
    kPPSFOAuthErrorJWTInvalidGrant,
    kPPSFOAuthErrorFetchUserAccountFailed // 無法取得帳號資訊
};

typedef void(^PPSFLoginCompleteHandler)(NSDictionary * __nullable params, NSError * __nullable error);
typedef NSMutableDictionary *_Nullable(^PPSFRequestAuthTokenHandler)(NSString * __nullable code, NSError ** __nullable error);

typedef void (^PPSFSendLoginActionHandler)(void);

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface PPSalesforceLoginView : WKWebView

@property (nonatomic, copy, nullable) PPSFRequestAuthTokenHandler requestAuthTokenHandler;
@property (nonatomic, copy, nullable) PPSFSendLoginActionHandler sendLoginActionHandler;

/**
 * 設定scopes,預設一定會加入"refresh_token", "api", 如果有其他的才需要額外加入
 */
@property (nonatomic, copy, nullable) NSSet *scopes;

/**
 * 使用自訂domain, 預設為nil, 表示標準登入(login.salesforce.com)
 * 需在 |showOAuthViewWithCompleteHandler:|之前設定
 */
@property (nonatomic, copy, nullable) NSString *customDomain;


- (instancetype)initWithClientID:(NSString *)clientID;

- (instancetype)initWithClientID:(NSString *)clientID secret:(NSString *__nullable)secret;

- (void)showOAuthViewWithCompleteHandler:(PPSFLoginCompleteHandler)completeHandler;

- (void)reloadOrigin;

@end
NS_ASSUME_NONNULL_END
