//
//  PPQRCodeController.h
//
//
//  Created by Howard.Lin on 14/2/25.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#import <Foundation/Foundation.h>

///////////////////////////////////////////////////////////////////////////////////////////////////

@class PPQRCodeController;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Protocol

@protocol PPQRCodeControllerDelegate <NSObject>

@required
- (void)ppQRCodeViewController:(PPQRCodeController *)ppQRCodeViewController
              withQRCodeString:(NSString *)string;
@end





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPQRCodeCaptureViewController()

@interface PPQRCodeController : NSObject



////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,assign) id<PPQRCodeControllerDelegate> delegate;

// 允許多張 QR Code Image 連續辨識 (預設 NO)
@property (nonatomic,assign) BOOL allowMultiQRCodeImageRecognition;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

/**
 *  目前待辨識 QR Image 任務數目
 *
 *  @return 待辨識 qr Image 任務數目
 */
- (NSUInteger)qrRecognitionOperationCount;


/**
 *  開始辨識 QR Code image
 *
 *  @param qrCodeImage 待辨識名片
 *  @param delegate    被委托者
 *  @param error       錯誤訊息
 *
 *  @return YES 開始進行辨識，不代表此圖(QR Code Image) 能辨識出資料
 */
- (BOOL)startRecognitionForQRCodeImage:(UIImage *)qrCodeImage delegate:(id<PPQRCodeControllerDelegate>)delegate error:(NSError **)error;


/**
 *  取消QR Code 辨識
 */
- (void)cancelQRCodeImageOperation;



////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

/**
 * Shared instance
 */
+ (PPQRCodeController *)qrCodeShareInstance;


/**
 * 產生"正方形"QRCode影像
 *
 * @param content 內容文字
 * @param sideLength 輸出影像邊長
 */
+ (UIImage *)QRCodeImageWithContent:(NSString *)content sideLength:(NSInteger)sideLength;


@end
