//
//  PPNetworkReachabilityController.h
//  
//
//  Created by Mike on 13/5/8.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <SystemConfiguration/SystemConfiguration.h>
#import <netinet/in.h>

////////////////////////////////////////////////////////////////////////////////////////////////////

#define PPNetworkReachabilityControllerChangedNotification	@"PPNetworkReachabilityControllerChangedNotification"

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSInteger, PPNetworkReachabilityControllerStatus)
{
	PPNetworkReachabilityControllerStatus_ReachableNone = 0,
	PPNetworkReachabilityControllerStatus_ReachableViaWiFi,
	PPNetworkReachabilityControllerStatus_ReachableViaWWAN,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPNetworkReachabilityController : NSObject
{
@private
	SCNetworkReachabilityRef	networkReachabilityRef_;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

- (BOOL)startNotifier;
- (void)stopNotifier;
- (PPNetworkReachabilityControllerStatus)status;
- (BOOL)connectionRequired;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

+ (PPNetworkReachabilityController *)networkReachabilityControllerWithAddress:(const struct sockaddr_in *)hostAddress;
+ (PPNetworkReachabilityController *)networkReachabilityControllerWithHostName:(NSString *)hostName;
+ (PPNetworkReachabilityController *)networkReachabilityControllerForInternetConnection;
+ (PPNetworkReachabilityController *)networkReachabilityControllerForLocalWiFi;
+ (BOOL)checkWithAddress:(const struct sockaddr_in *)hostAddress;
+ (BOOL)checkWithHostName:(NSString *)hostName;
+ (BOOL)checkForInternetConnection;
+ (BOOL)checkForLocalWiFi;

@end
