//
//  PPPincodeViewController.h
//  Pods
//
//  Created by sanhue on 2015/9/21.
//
//

#import <UIKit/UIKit.h>
#import "PPViewController.h"
#import "PPAppearance.h"

typedef NS_ENUM(NSUInteger,PPPincodeViewControllerStyle)
{
    PPPincodeViewControllerStyle_CreatePassword = 0,    ///< 建立密碼
    PPPincodeViewControllerStyle_ChangePassword,    ///< 變更密碼
    PPPincodeViewControllerStyle_CheckPassword,     ///< 檢查密碼
    PPPincodeViewControllerStyle_ClearPassword     ///< 清除密碼
};

////////////////////////////////////////////////////////////////////////////////////////////////////
@class PPPincodeViewController;

@protocol PPPincodeViewControllerDelegate <NSObject>


/**
 * 檢查密碼是否正確, check password會用到
 * @param pincodeViewController instance of PPPincodeViewController
 * @param password password to check
 * @return BOOL YES: 正確；NO:不正確
 */
- (BOOL)pincodeViewController:(PPPincodeViewController *)pincodeViewController checkPassword:(NSString *)password;

/**
 * 通知輸入結束
 * @param pincodeViewController instance of PPPincodeViewController
 * @param password password that user enter
 */
- (void)pincodeViewController:(PPPincodeViewController *)pincodeViewController didFinishWithPassword:(NSString *)password;

@optional
/**
 * 通知輸入的密碼錯誤
 * @param pincodeViewController instance of PPPincodeViewController
 */
- (void)didFailedWithPincodeViewController:(PPPincodeViewController *)pincodeViewController;
@end


////////////////////////////////////////////////////////////////////////////////////////////////////
@interface PPPincodeViewController : PPViewController <PPAppearance>

@property (nonatomic, assign) id<PPPincodeViewControllerDelegate> delegate;
@property (nonatomic, assign) PPPincodeViewControllerStyle style;


/// default NO
@property (nonatomic, assign) BOOL enableTouchID;

#pragma mark - style settings

@property (nonatomic, retain) UIColor *buttonHighlightedBackgroundColor PP_APPEARANCE_SELECTOR;
@property (nonatomic, assign) UIEdgeInsets buttonImageEdgeInsets PP_APPEARANCE_SELECTOR;
@end
