//
//  PPIndexingController.h
//  
//
//  Created by Mike on 13/5/28.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "NSString+Additions.h"
#import "PPIndexingController+ParameterDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPIndexingController : NSObject

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

/**
 * 取得indexd列表
 * @param style 指定的index style
 * @return array of index string
 */
+ (NSArray *)indexsForStyle:(PPIndexingStyle)style;

/**
 * 取得string的所屬的index
 * @param string 要取得index的字串
 * @param style index的style
 * @return index string，nil if not found
 */
+ (unsigned short)indexAliasOfString:(NSString *)string forStyle:(PPIndexingStyle)style;

/**
 * 取得string的所屬的index
 * @param string 要取得index的字串
 * @param style index的style
 * @return index string，nil if not found
 */
+ (NSString *)indexOfString:(NSString *)string forStyle:(PPIndexingStyle)style;

/**
 * 取得string的第一個讀音
 * @param string 要取得讀音的字串
 * @param style 讀音的style, 目前只支援PPIndexingStyle_Hiragana
 * @return phonetic string，nil if not found
 */
+ (NSString *)phoneticOfString:(NSString *)string forStyle:(PPIndexingStyle)style;

/**
 * 取得string的讀音，全部可能都列出
 * @param string 要取得讀音的字串
 * @param style 讀音的style, 目前只支援PPIndexingStyle_Hiragana
 * @return array of phonetic string，nil if not found
 */
+ (NSArray <NSString *>*)phoneticsOfString:(NSString *)string forStyle:(PPIndexingStyle)style;

@end
