//
//  PPImageScrollCropView.h
//  PPImageScrollCropView
//
//  Created by pp on 2011/6/26.
//  Copyright 2011 Penpower. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "PPImageScrollView.h"
#import "PPCropView.h"
#import <UIImage+Additions.h>

////////////////////////////////////////////////////////////////////////////////////////////////////
typedef struct _PPISCV_PPCropPoints
{
	CGPoint ptLeftTop;
	CGPoint ptRightTop;
	CGPoint ptRightBottom;
	CGPoint ptLeftBottom;
}PPISCV_CropPoints, *PPPISCV_CropPoints;





////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPImageScrollCropView()

@interface PPImageScrollCropView : PPImageScrollView 





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

/**
 *  是否隱藏cropView，預設為NO
 */
@property (nonatomic, getter=isCropViewHidden)      BOOL            cropViewHidden;

/**
 *  cropView是否為Enable，設為NO則cropView無法接受任何操作，預設為YES
 */
@property (nonatomic, assign)                       BOOL			enableResizeCrop;

/**
 *  設定點到cropView內部時能不能做移動，預設為NO
 */
@property (nonatomic, assign)                       BOOL            moveCropViewEnable;

/**
 *  是否使用矩形的Crop模式，預設為Yes
 */
@property (nonatomic, getter=isRectMode)            BOOL			rectCropMode;	

/**
 *  Crop區域的最大Size(相對於imageView的座標系)，預設為cropView.frame.size
 */
@property (nonatomic, assign)                       CGSize          maxCropSize;

/**
 *  設定crop point的半徑
 */
@property (nonatomic, assign)                       NSInteger		cropPointRadius;

/**
 *  邊界大於這個值時，會自動把要crop的圖做縮圖，預設長度為1600
 */
@property (nonatomic, assign)                       NSUInteger		maxEdgeLength;

/**
 *  未裁切前的原始圖片
 */
@property (nonatomic, readonly, retain)             UIImage			*originalImage;





////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance methods - Crop Points Coordinate Handling

/**
 *  Set initial crop points base on original image
 *
 *  @param initCropPoints The crop points array will be set
 */
- (void)setInitCropPoints:(PPISCV_CropPoints)initCropPoints;

/**
 *  Get crop points array base on 'self.imageview'
 *
 *  @param ppicvCropPoints The crop points array will be set
 *
 *  @return FALSE if 'ppicvCropPoints' is NULL, or equals to initial crop points.
 *          TRUE if 'ppicvCropPoints' is different from initial crop points.
 */
- (BOOL)getCropPointsOnView:(PPISCV_CropPoints*)ppicvCropPoints;

/**
 *  Get crop points array base on Original image
 *
 *  @param ppicvCropPoints The crop points array will be set
 *
 *  @return FALSE if 'ppicvCropPoints' is NULL or equals to initial crop points.
 *          TRUE if 'ppicvCropPoints' is different from initial crop points.
 */
- (BOOL)getCropPointsOnOriginalImage:(PPISCV_CropPoints*)ppicvCropPoints;

/**
 *  輸入Rect，並轉為對應到imageView的座標
 *
 *  @param originalRect 輸入的Rect
 *
 *  @return imageView座標的Rect
 */
- (CGRect)convertRectFromOriginalImage:(CGRect)originalRect;

/**
 *  輸入Rect，並轉為對應到原始圖片的座標
 *
 *  @param originalRect 輸入的Rect
 *
 *  @return 原始圖片坐標的Rect
 */
- (CGRect)convertRectToOriginalImage:(CGRect)originalRect;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods - Others

/**
 *  取得以CropPoints裁剪後的Image
 *
 *  @return Image that was croped
 */
- (UIImage*)imageCroped;

/**
 *  回傳包含四個crop points的最小Rectangle，對應到imageView座標系
 *
 *  @return 最小Rectangle
 */
- (CGRect)cropMinRect;

@end
