//
//  PPImageEnhanceController.h
//  
//
//  Created by Mike on 13/6/6.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import <Foundation/Foundation.h>

#if TARGET_OS_IPHONE
#import "UIImage+Additions.h"
#import "UIImage+BITMAPPTR.h"
#elif TARGET_OS_MAC
#import "NSImage+Additions.h"
#import "NSImage+BITMAPPTR.h"
#endif

#import "CrossPlatformDefine.h"
#import "PPQuadrilateralModel.h"
#import "imgenhance.h"

/**
 *  用以顯示目前Image處理進度的Block
 *
 *  @param progress 進度值 範圍為0.0~1.0
 */
typedef void (^PPImageEnchanceControllerProgressingBlock) (CGFloat progress);

@interface PPImageEnhanceController : NSObject

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

/**
 *  對影像進行扭正處理
 *
 *  @param image              欲處理之影像
 *  @param quadrilateralModel 扭正所使用的四邊形Model，給圖像上的四個Point之後對該區域進行扭正處理
 *  @param block              Progessing Block，用來顯示進度
 *
 *  @return 扭正處理後的Image
 */
+ (CPImage *)deskewImage:(CPImage *)image
  withQuadrilateralModel:(PPQuadrilateralModel *)quadrilateralModel
        progressingBlock:(PPImageEnchanceControllerProgressingBlock)block;

/**
 *  對影像進行扭正處理
 *
 *  @param image              欲處理之影像
 *  @param quadrilateralModel 扭正所使用的四邊形Model，給圖像上的四個Point之後對該區域進行扭正處理
 *
 *  @return 扭正處理後的Image
 */
+ (CPImage *)deskewImage:(CPImage *)image
  withQuadrilateralModel:(PPQuadrilateralModel *)quadrilateralModel;

/**
 *  對影像進行亮度校正處理
 *
 *  @param image              欲處理之影像
 *
 *  @return 亮度校正後的Image
 */
+ (CPImage *)lightCorrectImage:(CPImage *)image;

/**
 *  對影像進行亮度校正處理
 *
 *  @param image              欲處理之影像
 *  @param block              Progessing Block，用來顯示進度
 *
 *  @return 亮度校正後的Image
 */
+ (CPImage *)lightCorrectImage:(CPImage *)image
              progressingBlock:(PPImageEnchanceControllerProgressingBlock)block;

/**
 *  取得整張影像範圍的QuadrilateralModel(初始化時使用)
 *
 *  @param image 欲取得QuadrilateralModel的圖像
 *
 *  @return Quadrilateral
 */
+ (PPQuadrilateralModel *)houghTransformQuadrilateralModelForImage:(CPImage *)image;
@end
