//
//  PPGuideAttributeModel.h
//
//  Created by eddie on 2015/4/1.
//

#import <UIKit/UIKit.h>
#import "PPGuideFocusModel.h"

@interface PPGuideAttributeModel : NSObject

/**
 * 遮罩顏色
 */
@property (nonatomic, retain) UIColor *maskColor;

/**
 * 遮罩是否使用模糊背景
 */
@property (nonatomic, assign) BOOL useBlurBackground;


/**
 * 焦點區域相關資料
 */
@property (nonatomic, retain) PPGuideFocusModel *guideFocus;


/**
 * title字型
 */
@property (nonatomic, retain) UIFont *titleFont;

/**
 * title顏色
 */
@property (nonatomic, retain) UIColor *titleColor;

/**
 * message字型
 */
@property (nonatomic, retain) UIFont *messageFont;

/**
 * message顏色
 */
@property (nonatomic, retain) UIColor *messageColor;

/**
 * confirm按鈕，沒有設定則整個GuideView都可點選。
 */
@property (nonatomic, retain) UIButton *confirmButton;


@end
