//
//  PPGoogleAuthenticationController.h
//  !! 目前的架構只能提供一組服務使用，多組要使用時需調整。
//  

#import <Foundation/Foundation.h>
#import <GTMAppAuth/GTMAppAuth.h>
#import <AppAuth/AppAuthCore.h>


////////////////////////////////////////////////////////////////////////////////////////////////////
@protocol PPGoogleAuthenticationControllerDelegate <NSObject>
@optional
- (void)logMessage:(NSString *)message sender:(id)sender;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPGoogleAuthenticationController : NSObject
@property (nonatomic, retain) id<OIDExternalUserAgentSession> currentAuthorizationFlow;
+ (void)setDelegate:(id<PPGoogleAuthenticationControllerDelegate>)delegate;

/// 初始化
+ (BOOL)initializeWithKeychainName:(NSString *)keychainName
                          clientID:(NSString *)clientID
                      clientSecret:(NSString *)clientSecret;

/// 最新的GoogleAuthentication
+ (GTMAppAuthFetcherAuthorization *)lastAuthentication;

/// 重新取得Authentication token
+ (void)renewGoogleAuthentication;

/// 儲存authentication到keychain並更新lastAuthentication
+ (BOOL)saveGoogleAuthentication:(GTMAppAuthFetcherAuthorization *)authentication;

/// 從keychain移除authentication並清空lastAuthentication
+ (void)removeGoogleAuthentication;


    //////////////////////////////////////////////////

typedef void(^GoogleSignInCompleteHandler)(id<GTMFetcherAuthorizationProtocol> auth, NSError *error);
typedef void(^IncrementalAuthorizationCompleteHandler)(id<GTMFetcherAuthorizationProtocol> auth, NSError *error);


// 顯示登入介面
#if  TARGET_OS_IOS

+ (void)showSignInWithScopes:(NSArray *)scopes
              viewController:(UIViewController *)viewController
             completeHandler:(GoogleSignInCompleteHandler)handler;

+ (void)incrementalAuthorizationWithScopes:(NSArray *)scopes
                            viewController:(UIViewController *)viewController          completeHandler:(IncrementalAuthorizationCompleteHandler)handler;


#elif TARGET_OS_MAC
+ (void)showSignInWithScopes:(NSArray *)scopes
             completeHandler:(GoogleSignInCompleteHandler)handler;

+ (void)incrementalAuthorizationWithScopes:(NSArray *)scopes                           completeHandler:(IncrementalAuthorizationCompleteHandler)handler;

#endif



    // handleOpenURL, 在AppDelegate中使用
+ (BOOL)handleOpenURL:(NSURL *)url;

/// 更換Auth的keychain name,  clientID, secrect
+ (void)replaceAppAuthWithNewKeyChainName:(NSString *)newKeyChainName
                      fromOldKeyChainName:(NSString *)oldkeyChainName
                              oldClientID:(NSString *)oldClientID
                             oldSecrectID:(NSString *)oldSecrectID;


+ (PPGoogleAuthenticationController *)sharedInstance;

@end
