//
//  PPDataConverter.h
//
//  Created by eddie on 2015/9/7.
//
//

#import <Foundation/Foundation.h>

////////////////////////////////////////////////////////////////////////////////////////////////////
/// Delegate
@class PPDataConverter;
@protocol PPDataConverterDelegate <NSObject>
@optional

/**
 * Set current access percentage
 *
 * @param dataConverter - Data converter instance
 * @param accessProgress - Convert progress, value from 0.0 to 1.0.
 */
- (void)dataConverter:(PPDataConverter *)dataConverter accessProgress:(float)accessProgress;

/**
 * Set log from converter
 *
 * @param dataConverter - Data converter instance
 * @param log - Log message
 */
- (void)dataConverter:(PPDataConverter *)dataConverter addSubLog:(NSString *)log;

@end



////////////////////////////////////////////////////////////////////////////////////////////////////
/// Protocol that must apply in converter

@protocol PPDataConverterProtocol <NSObject>
@required

/// Need run this convert or not
- (BOOL)needConvert;

/// Do convert process
- (BOOL)doConvertWithDelegate:(id<PPDataConverterDelegate>)delegate error:(NSError **)error;



@optional

/// 是否需要備份資料（注意沒有實作代表"需要"備份）
- (BOOL)needBackup;

@end



////////////////////////////////////////////////////////////////////////////////////////////////////
/// Converter object

@interface PPDataConverter : NSObject <PPDataConverterProtocol>

/// Identifier of converter
@property (nonatomic, assign) id<PPDataConverterDelegate> delegate;
@property (nonatomic, retain) NSString *key;

/**
 * Initialize converter
 *
 * @param key - Key of converter;
 * @return PPDataConverter instance
 */
+ (instancetype)converterWithKey:(NSString *)key;



@end
