//
//  PPDataConvertFlowController.h
//
//  Created by eddie on 2015/9/7.
//  Copyright (c) 2015年 penpower. All rights reserved.
//
//  驗證流程：
//  1. 正常轉換成功
//  2. disk空間不足
//  3. 備份失敗
//  4. 轉換中間app被關閉(從task移除)
//  5. 轉換失敗選擇回報錯誤
//  6. 轉換失敗選擇放棄轉換
//  7. 版本再升級的後續轉換
//  8. 版本再升級時會刪除舊版的備份資料
//

#import <Foundation/Foundation.h>
#import "CrossPlatformDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#define PPDataConvertFlowController_ZipPassword @"io9#IH93(mlkas@0"

////////////////////////////////////////////////////////////////////////////////////////////////////
@class PPDataConverter;
@interface PPDataConvertFlowController : NSObject

/**
 Start convert flow (iOS use)

 @param dataDirPath 資料路徑
 @param converters 轉換元件
 @param messageColor 訊息顏色
 @param backgroundColor 背景顏色
 @param completion 完成時的回報
 */
+ (void)startWithDataDirPath:(NSString *)dataDirPath
                  converters:(NSArray<PPDataConverter*> *)converters
                messageColor:(CPColor *)messageColor
             backgroundColor:(CPColor *)backgroundColor
                  completion:(void (^)(BOOL success))completion;

/**
 Start convert flow (macOS use)

 @param dataDirPath 資料路徑
 @param backupFileSuffix 備份檔名加入的後綴字串
 @param converters 轉換元件
 @param completion 完成時的回報
 */
+ (void)startWithDataDirPath:(NSString *)dataDirPath
            backupFileSuffix:(NSString *)backupFileSuffix
                  converters:(NSArray<PPDataConverter*> *)converters
                  completion:(void (^)(BOOL success))completion;

/**
 Get log directory path

 @return Path string
 */
+ (NSString *)logDirPath;


/**
 Get backup directory path

 @return Path string
 */
+ (NSString *)backupDirPath;

@end
