//
//  PPCropView.h
//  WorldCardContacts
//
//  Created by sanhue on 2011/07/20.
//  Copyright 2009 Penpower. All rights reserved.
//
//	此元件永達比他的SuperView大, 上下左右都會擴充四個角的點的半徑

#import <UIKit/UIKit.h>

// View
#import "PPMagnifierView.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef enum
{
	PPCV_SM_LeftTop = 0,
	PPCV_SM_RightTop,
	PPCV_SM_RightBottom,
	PPCV_SM_LeftBottom,
	PPCV_SM_Top,
	PPCV_SM_Left,
	PPCV_SM_Right,
	PPCV_SM_Bottom,
	
	PPCV_SM_Count
}
PPCV_SELECTMARK;

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPCropView : UIView 
{
 @private
    
    //////////////////////////////////////////////////
	// 要做crop的Imageview的大小, 也是Crop Point的最大值
    
    BOOL		magnifierEnable_;						// 是否開啟放大鏡功能
//	BOOL		moveLineMode_;							// 是否可以直接移動線
    BOOL		moveCropViewEnable_;					// 是否可以直接移動cropView
    BOOL		rectCropMode_;							// 是否為矩形模式
    BOOL		smallLineMode_;							// 是否要畫較小的線
    BOOL		touchEnable_;							// 是否可以移動crop, 開啟後才可以做其他的動作
    CGPoint		_cropPointOfView[PPCV_SM_Count];		// 目前crop的四個角的座標
    CGPoint		_imagePointOfView[PPCV_SM_Count/2];		// 原始的crop的四個角的座標
    CGPoint		confirmedTouchPoint_;					// 經過確認為有效的座標點(超過'PPCV_CONFIRM_TIMEINTERVAL'秒)
    CGPoint		lastMovePoint_;							// 未經確認為有效座標的點
    CGPoint		moveStartPoint_;						// 移動的開始點
    CGRect		_markFrame[PPCV_SM_Count];				// 四個選取點的Frame size
    CGRect		imageFrame_;
	CGSize		maxSize_;								// crop rectangle的最大size
    CGSize		minSize_;								// crop rectangle的最小size
    CIColor     *lineColor_;                            // crop的線的顏色
    NSInteger   cropPointRadius_ ;                      // crop point 的半徑
    NSInteger	currentSelectedMark_;					// 目前點選的要修正的點
	NSTimer		*touchConfirmTimer_;					// 確認是否為有效的點擊
    UITouch		*currentTouchPoint_;					// 目前的touch point
    
    PPMagnifierView  *ppMagnifierView_;					// 放大鏡元件
}

@property (nonatomic, assign, getter=isMagnifierEnable) BOOL			magnifierEnable;        // default YES
@property (nonatomic, assign)                           BOOL            moveCropViewEnable;     // default NO
@property (nonatomic, assign, getter=isRectMode)        BOOL			rectCropMode;           // default YES
@property (nonatomic, assign)                           BOOL            smallLineMode;          // default NO
@property (nonatomic, assign)                           BOOL            touchEnable;            // default YES
@property (nonatomic, assign)                           CGSize          maxSize;
@property (nonatomic, assign)                           NSInteger       cropPointRadius;

@property (nonatomic, readonly, retain)                 PPMagnifierView	*ppMagnifierView;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - instance methods

/**
 * return NO if not crop
 *
 * @param cropPoints cropPoints
 *
 * @return NO if not crop
 */
- (BOOL)getCropPointArray:(CGPoint*)cropPoints;


/**
 * 取得包含四個crop點的最小rect
 *
 * @return 包含四個crop點的最小rect
 */
- (CGRect)minimizeRect;


/**
 * 清除'imageFrame'的初始值，為empty時才要重算
 */
- (void)resetInitImageFrame __deprecated;


/**
 * return NO if set array failed
 *
 * @param cropPoints cropPoints
 *
 * @return NO if set array failed
 */
- (BOOL)setCropPointArray:(CGPoint*)cropPoints;


/**
 * 設定影像在螢幕上的大小
 *
 * @param theImageFrame 影像大小
 */
- (void)setInitialImageFrame:(CGRect)theImageFrame;


/**
 * set line color for crop
 *
 * @param lineColor line color for crop
 **/
- (void)setLineColor:(CIColor*)lineColor;

/**
 *  調整 cropView 大小
 * 處理方式:當父視圖大小異動時 (ex 畫面旋轉),調整 cropView大小
 */
- (void)adjustCropViewFrame;
@end
