//
//  PPCloudController.h
//
//
//  Created by Mike on 13-3-11.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "PPCloud.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPCloudController : NSObject
{
@private
    NSMutableDictionary *cloudDictionary_;
    NSOperationQueue    *operationQueue_;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

- (BOOL)handleOpenURL:(NSURL *)url;
- (BOOL)isLinkedWithCloudClass:(Class)cloudClass;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Protocol Methods

- (BOOL)copyFrom:(NSString*)fromPath toPath:(NSString *)toPath delegate:(id<PPCloudDelegate_Copy>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass;
- (BOOL)createFolder:(NSString *)createFolder delegate:(id<PPCloudDelegate_CreateFolder>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass;
- (BOOL)deletePath:(NSString *)deletePath delegate:(id<PPCloudDelegate_Delete>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass;
- (BOOL)linkFromController:(CPCLViewController *)viewcontroller delegate:(id<PPCloudDelegate_Link>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass;
- (BOOL)loadAccountInfoWithDelegate:(id<PPCloudDelegate_LoadAccountInfo>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass;

- (BOOL)loadFileFromPath:(NSString *)filePath
                orFileID:(NSString *)fileID
                intoPath:(NSString *)intoPath
                delegate:(id<PPCloudDelegate_LoadFile>)delegate
                userInfo:(id)userInfo cloudClass:(Class)cloudClass;

- (BOOL)loadMetadata:(NSString *)loadMetadata delegate:(id<PPCloudDelegate_LoadMetadata>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass;
- (BOOL)loadThumbnail:(NSString *)loadThumbnail ofSize:(NSString *)size intoPath:(NSString *)intoPath delegate:(id<PPCloudDelegate_LoadThumbnail>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass;
- (BOOL)moveFrom:(NSString *)moveFrom toPath:(NSString *)toPath delegate:(id<PPCloudDelegate_Move>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass;
- (BOOL)unlinkWithDelegate:(id<PPCloudDelegate_Unlink>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass;
- (BOOL)uploadFile:(NSString *)filename toPath:(NSString *)toPath fromPath:(NSString *)fromPath delegate:(id<PPCloudDelegate_UploadFile>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass;
- (BOOL)sharedlinkFile:(NSString *)sharedlinkFile delegate:(id<PPCloudDelegate_Sharedlink>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass; //Support GoogleDrive

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

+ (PPCloudController *)sharedCloudController;
+ (void)setSharedCloudController:(PPCloudController *)cloudController;
+ (void)setParameter:(id)parameter forKey:(NSString *)key;
+ (BOOL)handleOpenURL:(NSURL *)url;
+ (BOOL)isLinkedWithCloudClass:(Class)cloudClass;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Protocol Methods

+ (BOOL)copyFrom:(NSString*)fromPath toPath:(NSString *)toPath delegate:(id<PPCloudDelegate_Copy>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass;
+ (BOOL)createFolder:(NSString *)createFolder delegate:(id<PPCloudDelegate_CreateFolder>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass;
+ (BOOL)deletePath:(NSString *)deletePath delegate:(id<PPCloudDelegate_Delete>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass;
+ (BOOL)linkFromController:(CPCLViewController *)viewcontroller delegate:(id<PPCloudDelegate_Link>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass;
+ (BOOL)loadAccountInfoWithDelegate:(id<PPCloudDelegate_LoadAccountInfo>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass;

+ (BOOL)loadFileFromPath:(NSString *)filePath
                orFileID:(NSString *)fileID
                intoPath:(NSString *)intoPath
                delegate:(id<PPCloudDelegate_LoadFile>)delegate
                userInfo:(id)userInfo cloudClass:(Class)cloudClass;

+ (BOOL)loadMetadata:(NSString *)loadMetadata delegate:(id<PPCloudDelegate_LoadMetadata>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass;
+ (BOOL)loadThumbnail:(NSString *)loadThumbnail ofSize:(NSString *)size intoPath:(NSString *)intoPath delegate:(id<PPCloudDelegate_LoadThumbnail>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass;
+ (BOOL)moveFrom:(NSString *)moveFrom toPath:(NSString *)toPath delegate:(id<PPCloudDelegate_Move>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass;
+ (BOOL)unlinkWithDelegate:(id<PPCloudDelegate_Unlink>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass;
+ (BOOL)uploadFile:(NSString *)filename toPath:(NSString *)toPath fromPath:(NSString *)fromPath delegate:(id<PPCloudDelegate_UploadFile>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass;
+ (BOOL)sharedlinkFile:(NSString *)sharedlinkFile delegate:(id<PPCloudDelegate_Sharedlink>)delegate userInfo:(id)userInfo cloudClass:(Class)cloudClass; //Support GoogleDrive
+ (void)cancelAllOperations;

/**
 *  設定所有 Operation Delegate
 *  處理方式: 當delegate的實體會被dealloc時，operation 還沒跑完，就要先把 delegate = nil
 *  @param operationDelegate 被委託者實體
 */
+ (void)setOperationDelegate:(id)operationDelegate;
+ (NSUInteger)operationCount;

@end
