//
//  PPClipContactPhotoViewController
//
//
//  Created by Andrewlia on 13/12/13.
//  Copyright (c) 2013年 penpower. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "PPBusyView.h"
#import "PPButton.h"
#import "PPTitleBarView.h"
#import "PPViewController.h"
#import "PPImageScrollView.h"


////////////////////////////////////////////////////////////////////////////////////////////////////

static CGFloat PPClipContactPhotoViewControllerDefaultMaximumZoomScale = 4.0f;
static CGSize  PPClipContactPhotoViewControllerDefaultMaxmumImageSize  = {1936,2592};

static CGFloat PPClipContactPhotoViewControllerToolBarHeightWhenLandscape = 44;

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSInteger, PPClipContactPhotoViewControllerButtonTag)
{
    PPClipContactPhotoViewControllerButtonTag_None = 0,
    PPClipContactPhotoViewControllerButtonTag_Cancel,
    PPClipContactPhotoViewControllerButtonTag_Choose
};





////////////////////////////////////////////////////////////////////////////////////////////////////

@class PPClipContactPhotoViewController;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Protocol

@protocol PPClipContactPhotoViewControllerDelegate <NSObject>

@required
- (void)ppClipContactPhotoViewController:(PPClipContactPhotoViewController *)ppClipContactPhotoViewController resignContactPhoto:(UIImage *)contactPhoto;
- (void)ppClipContactPhotoViewControllerDidCancel:(PPClipContactPhotoViewController *)ppClipContactPhotoViewController;

@optional

- (BOOL)compactImageWithPPClipContactPhotoViewControllerDidImageCheckSize:(PPClipContactPhotoViewController *)ppClipContactPhotoViewController;
- (void)compactImage:(UIImage *)compactImage withPPClipContactPhotoViewController:(PPClipContactPhotoViewController *)ppClipContactPhotoViewController;

@end





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPClipContactPhotoViewController()

@interface PPClipContactPhotoViewController : PPViewController <PPButtonDelegate, UIScrollViewDelegate>





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic, assign) id<PPClipContactPhotoViewControllerDelegate>   delegate;
@property (nonatomic, assign) float                                          maximumZoomScale;
@property (nonatomic, assign) CGSize                                         maxmumSizeOfSourceImage;
@property (nonatomic, retain) UIImage                                        *sourceImage;

@property (nonatomic, retain) UIColor                                        *backgroundColorForToolBar; //預設透明
@property (nonatomic, retain) UIColor                                        *textColorForToolBar; //預設白色
@property (nonatomic, retain) UIColor                                        *backgroundColorForTitleBar; //預設透明
@property (nonatomic, retain) UIColor                                        *textColorForTitleBar; //預設白色
@property (nonatomic, retain) UIColor                                        *backgroundColorForMask; //預設黑色透明度0.5

@end
